/****************************************************************************
 *                           forkexec.c  -  description
 *                              -------------------
 *     begin                : Sun Jun 2 2002
 *     copyright            : (C) 2002 by Pete Gray
 *     email                : petegray@attbi.com
 ****************************************************************************/

/*****************************************************************************
 *                                                                           *
 *     This program is free software; you can redistribute it and/or modify  *
 *     it under the terms of the GNU General Public License as published by  *
 *     the Free Software Foundation; either version 2 of the License, or     *
 *     (at your option) any later version.                                   *
 *                                                                           *
 *****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
/* #include <process.h> */
#include <stdlib.h>
#include <pwd.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>

#include "tdsd.h"

extern char     *tdsdir, tdssta[255];
time_t now;
FILE   *fps;
struct tds_status_struct tds;

void set_status (char state, int completion_status, pid_t pid);
void addenv (char **e, char *var, char *val);
void concat (char *result, char *s1, char *s2, char *s3);

int start_job (char *command, char *user, char *jobname, char *outdir, char *tdsrestart)
{
   pid_t  pid, pid2, wpid, gpid, tpid;
   gid_t  gid;
   int    status;
   FILE   *fp;
   struct passwd* pw;
   char   *envlist[7] = {NULL,NULL,NULL,NULL,NULL,NULL,NULL};
   char   *shell="/bin/bash", ffn[255], tdsdesc[32];

   /* flush to prevent duplication of output */
   fflush (NULL);
   if ( ( pid = fork() ) == -1) {
      printf ("Could not create child process for job %s\n",jobname);
      perror ("fork");
      return EXIT_FAILURE;
   }

   /* fork and exit, for setsid() ... */
   if (pid!=0)
     if ((tpid = fork()) > 0) exit (EXIT_SUCCESS);

   if (pid==0) { /* the monitor child */

      if ( (pw = getpwnam ( user )) == NULL) {
	 printf ("Problem with user %s (job %s)\n",user,jobname);
	 perror ("getpwnam");
	 set_status (ERROR,errno,0);
	 exit (EXIT_FAILURE);
      }
      gpid = setsid(); 
      if (gpid == -1) perror ("setsid");
      setgid (pw->pw_gid);
      (void) initgroups (pw->pw_name,pw->pw_gid);
      setuid (pw->pw_uid);
      chdir (pw->pw_dir);
      umask (S_IRWXG | S_IRWXO);

      concat (ffn,tdssta,"/",jobname);
      if ( (fps = fopen (ffn,"r+")) == NULL) {
	 printf ("Child cannot open status file (%s) for job %s\n",ffn,jobname);
	 perror ("fopen");
	 exit (EXIT_FAILURE);
      }
      concat (ffn,outdir,jobname,NULL);
      if ( (fp = freopen (ffn,"w",stdout)) == NULL) {
	 printf ("Cannot open error file (%s) for job %s\n",ffn,jobname);
	 perror ("freopen");
	 set_status (ERROR,errno,0);
	 exit (EXIT_FAILURE);
      }
      dup2 (STDOUT_FILENO,STDERR_FILENO);
      now = time (NULL);
      printf ("%sStarting job monitor [pid %d, user %s] for %s\n",
	      ctime(&now),getpid(),pw->pw_name,jobname);
      fflush(NULL);
      if ( ( pid2 = fork() ) == -1) {
	 printf ("Monitor could not create child process\n");
	 perror ("fork");
	 set_status (ERROR,errno,0);
	 exit (EXIT_FAILURE);
      }
      if (pid2 == 0) { /* the actual process */
	 printf ("Starting shell [pid %d], (command %s), ",getpid(),command);
	 if (tdsrestart[0])
	   printf ("restart point is %s\n",tdsrestart);
	 else
	   printf ("no restart point\n");
	 fflush(NULL);
	 addenv (&envlist[0],"TDSJOBNAME=",jobname);
	 addenv (&envlist[1],"TDSDIR=",tdsdir);
	 addenv (&envlist[2],"HOME=",pw->pw_dir);
	 addenv (&envlist[3],"USER=",pw->pw_name);
	 addenv (&envlist[4],"SHELL=",pw->pw_shell);
	 if (tdsrestart[0])
	   addenv (&envlist[5],"TDSRESTART=",tdsrestart);
	 else
	   addenv (&envlist[5],"TDSRESTART=","UNSET");
	 set_status (RUNNING,0,getpid());
	 sprintf (tdsdesc,"TDS [%s]",jobname);
	 if (pw->pw_shell == NULL)
           execle (shell,tdsdesc,"-c",command,NULL,envlist);
	 else
	   execle (pw->pw_shell,tdsdesc,"-c",command,NULL,envlist);
         perror ("execle");
	 set_status (ERROR,errno,0);
         exit (EXIT_FAILURE);
      }
      else {
	 do {
	    wpid = waitpid (pid2, &status, 0);
	 } while ( WIFEXITED(status) == 0);
	 now = time (NULL);
	 printf ("%sEnding job monitor for %s, status is %d\n",
		 ctime(&now),jobname,WEXITSTATUS(status));
	 if (WEXITSTATUS(status) == 0)
	   set_status (COMPLETED,0,pid2);
	 else
	   set_status (ERROR,WEXITSTATUS(status),pid2);
	 exit (EXIT_SUCCESS);
      }
   }
   else { /* the parent */
     now = time(NULL);
     printf ("%sINIT Job %s (user %s) initiated\n",ctime(&now),jobname,user);
   }
   return EXIT_SUCCESS;
}

void addenv (char **e, char *var, char *val)
{
   *e = malloc (strlen(var)+strlen(val)+1);
   strcpy (*e, var);
   strcat (*e, val);
   return;
}

void concat (char *result, char *s1, char *s2, char *s3)
{
   strcpy (result, s1);
   strcat (result, s2);
   if (s3) strcat (result, s3);
   return;
}

void set_status (char state, int status, pid_t pid)
{
   fread (&tds,sizeof(struct tds_status_struct),1,fps);
   fseek (fps,0,SEEK_SET);
   now = time(NULL);
   switch (state) {
    case RUNNING:
      tds.time_started = now;
      tds.pid = pid;
      break;
    case COMPLETED:
      tds.checkpoint[0] = '\0';
      tds.state_requested = NOREQUEST;
    case ERROR:
      tds.time_completed = now;
      tds.pid = pid;
      break;
   }
   tds.state = state;
   tds.completion_status = status;
   fwrite (&tds,sizeof(struct tds_status_struct),1,fps);
   fflush (fps);
   fseek (fps,0,SEEK_SET);
   return;
}
