/*
 * Copyright 1990 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by John F. Haugh, II
 *      and other contributors.
 * 4. Neither the name of John F. Haugh, II nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JOHN HAUGH AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JOHN HAUGH OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/types.h>
#include "config.h"
#include "defines.h"
#include <stdio.h>
#include "pwd.h"

#ifndef	lint
static char rcsid[] = "$Id: pwpack.c,v 1.2 1995/12/17 03:50:36 marekm Exp $";
#endif

/*
 * pw_pack - convert a (struct pwd) to a packed record
 */

int
pw_pack (passwd, buf)
struct	passwd	*passwd;
char	*buf;
{
	char	*cp;

	cp = buf;
	strcpy (cp, passwd->pw_name);
	cp += strlen (cp) + 1;

	strcpy (cp, passwd->pw_passwd);
#ifdef	ATT_AGE
	if (passwd->pw_age[0]) {
		*cp++ = ',';
		strcat (cp, passwd->pw_age);
	}
#endif
	cp += strlen (cp) + 1;

	memcpy (cp, (void *) &passwd->pw_uid, sizeof passwd->pw_uid);
	cp += sizeof passwd->pw_uid;

	memcpy (cp, (void *) &passwd->pw_gid, sizeof passwd->pw_gid);
	cp += sizeof passwd->pw_gid;
#ifdef	BSD_QUOTAS
	memcpy (cp, (void *) &passwd->pw_quota, sizeof passwd->pw_quota);
	cp += sizeof passwd->pw_quota;
#endif
#ifdef	ATT_COMMENT
	if (passwd->pw_comment) {
		strcpy (cp, passwd->pw_comment);
		cp += strlen (cp) + 1;
	} else
		*cp++ = '\0';
#endif
	strcpy (cp, passwd->pw_gecos);
	cp += strlen (cp) + 1;

	strcpy (cp, passwd->pw_dir);
	cp += strlen (cp) + 1;

	strcpy (cp, passwd->pw_shell);
		cp += strlen (cp) + 1;

	return cp - buf;
}

/*
 * pw_unpack - convert a packed (struct pwd) record to a (struct pwd)
 */

int
pw_unpack (buf, len, passwd)
char	*buf;
int	len;
struct	passwd	*passwd;
{
	char	*org = buf;
#ifdef	ATT_AGE
	char	*cp;
#endif

	bzero (passwd, sizeof *passwd);

	passwd->pw_name = buf;
	buf += strlen (buf) + 1;
	if (buf - org > len)
		return -1;

	passwd->pw_passwd = buf;
	buf += strlen (buf) + 1;
	if (buf - org > len)
		return -1;

#ifdef	ATT_AGE
	if (cp = strchr (passwd->pw_passwd, ',')) {
		*cp++ = '\0';
		passwd->pw_age = cp;
	} else
		passwd->pw_age = "";
#endif

	memcpy ((void *) &passwd->pw_uid, (void *) buf, sizeof passwd->pw_uid);
	buf += sizeof passwd->pw_uid;
	if (buf - org > len)
		return -1;

	memcpy ((void *) &passwd->pw_gid, (void *) buf, sizeof passwd->pw_gid);
	buf += sizeof passwd->pw_gid;
	if (buf - org > len)
		return -1;

#ifdef	BSD_QUOTAS
	memcpy ((void *) &passwd->pw_quota, (void *) buf,
		sizeof passwd->pw_quota);
	buf += sizeof passwd->pw_quota;
	if (buf - org > len)
		return -1;
#endif
#ifdef	ATT_COMMENT
	passwd->pw_comment = buf;
	buf += strlen (buf) + 1;
	if (buf - org > len)
		return -1;
#endif
	passwd->pw_gecos = buf;
	buf += strlen (buf) + 1;
	if (buf - org > len)
		return -1;

	passwd->pw_dir = buf;
	buf += strlen (buf) + 1;
	if (buf - org > len)
		return -1;

	passwd->pw_shell = buf;
	buf += strlen (buf) + 1;
	if (buf - org > len)
		return -1;

	return 0;
}
