/*
 * Copyright 1989 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by John F. Haugh, II
 *      and other contributors.
 * 4. Neither the name of John F. Haugh, II nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JOHN HAUGH AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JOHN HAUGH OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	lint
static char rcsid[] = "$Id: obscure.c,v 1.1 1995/12/16 01:15:45 marekm Exp $";
#endif

/*
 * This version of obscure.c contains modifications to support "cracklib"
 * by Alec Muffet (alec.muffett@uk.sun.com).  You must obtain the Cracklib
 * library source code for this function to operate.
 */

#include <ctype.h>
#include "config.h"
#include "prototypes.h"
#include "defines.h"

extern	int	getdef_bool();
extern	int	getdef_num();

#ifdef	NEED_STRSTR
/*
 * strstr - find substring in string
 */

char *
strstr (string, pattern)
char	*string;
char	*pattern;
{
	char	*cp;
	int	len;

	len = strlen (pattern);

	for (cp = string;cp = strchr (cp, *pattern);) {
		if (strncmp (cp, pattern, len) == 0)
			return cp;

		cp++;
	}
	return 0;
}
#endif

static char *
str_lower(string)
	char *string;
{
	char *cp;

	for (cp = string; *cp; cp++)
		*cp = tolower(*cp);
	return string;
}

/* return malloced copy of string truncated to maxlen chars */
static char *
str_truncate(string, maxlen)
	char *string;
	int maxlen;
{
	if (strlen(string) > maxlen) {
		char *newstr = xmalloc(maxlen + 1);
		memcpy(newstr, string, maxlen);
		newstr[maxlen] = '\0';
		return newstr;
	}

	return xstrdup(string);
}

/*
 * Obscure - see if password is obscure enough.
 *
 *	The programmer is encouraged to add as much complexity to this
 *	routine as desired.  Included are some of my favorite ways to
 *	check passwords.
 */

/* Separated the checks now that they are called twice, and changed to use
   dynamic allocation.  No more danger of long passwords overflowing 32-char
   buffers...  CRACKLIB_DICTPATH now in /etc/login.defs.  --marekm */

static int
password_check(old, new)
	char *old;
	char *new;
{
	char *oldmono, *newmono, *wrapped;
#ifdef USE_CRACKLIB
	char *msg, *dictpath;
	char *FascistCheck();
#endif

	if (strcmp (new, old) == 0) {	/* the same */
		printf ("No Change.  ");
		return (0);
	}

	oldmono = str_lower(xstrdup(old));
	newmono = str_lower(xstrdup(new));
	wrapped = xmalloc(strlen(oldmono) * 2 + 1);
	strcpy (wrapped, oldmono);
	strcat (wrapped, oldmono);

	if (palindrome (oldmono, newmono))	/* a palindrome */
		goto fail;

	if (strcmp (oldmono, newmono) == 0) {	/* case shifted */
		printf ("Case changes only.  ");
		goto fail;
	}
	if (similiar (oldmono, newmono))	/* jumbled version */
		goto fail;

	if (simple (old, new))			/* keyspace size */
		goto fail;

	if (strstr (wrapped, newmono)) {
		printf ("Rotated.  ");
		goto fail;
	}

#ifdef USE_CRACKLIB
	/*
	 * Invoke Alec Muffett's cracklib routines.
	 */

	dictpath = getdef_str("CRACKLIB_DICTPATH");
	if (dictpath && (msg = FascistCheck (new, dictpath))) {
		printf("Bad Password: %s.  ", msg);
		goto fail;
	}
#endif
	free(oldmono);
	free(newmono);
	free(wrapped);
	return 1;

fail:
	free(oldmono);
	free(newmono);
	free(wrapped);
	return 0;
}

/*ARGSUSED*/
int	obscure (old, new)
char	*old;
char	*new;
{
	int	maxlen;

#if 0  /* why not check the password when set for the first time?  --marekm */
	if (old[0] == '\0')
		return (1);
#endif

	if ( strlen(new) < getdef_num("PASS_MIN_LEN", 0) ) {
		printf ("Too short.  ");
		return (0);
	}

	/*
	 * Remaining checks are optional.
	 */
	if ( !getdef_bool("OBSCURE_CHECKS_ENAB") )
		return (1);

	if (!password_check(old, new))
		return 0;

	/* The traditional crypt() truncates passwords to 8 chars.  It is
	   possible to circumvent the above checks by choosing an easy
	   8-char password and adding some random characters to it...
	   Example: "password$%^&*123".  So check it again, this time
	   truncated to the maximum length.  Idea from npasswd.  Change
	   the value in login.defs if you have better crypt().  --marekm */

	maxlen = getdef_num("PASS_MAX_LEN", 8);
	if (strlen(old) <= maxlen && strlen(new) <= maxlen)
		return 1;

	printf("Warning: only first %d characters are significant.\n", maxlen);
	old = str_truncate(old, maxlen);
	new = str_truncate(new, maxlen);

	if (!password_check(old, new)) {
		free(old);
		free(new);
		return 0;
	}

	free(old);
	free(new);
	return (1);
}

/*
 * can't be a palindrome - like `R A D A R' or `M A D A M'
 */

/*ARGSUSED*/
int	palindrome (old, new)
char	*old;
char	*new;
{
	int	i, j;

	i = strlen (new);

	for (j = 0;j < i;j++)
		if (new[i - j - 1] != new[j])
			return (0);

	printf ("A palindrome.  ");
	return (1);
}

/*
 * more than half of the characters are different ones.
 */

/*ARGSUSED*/
int	similiar (old, new)
char	*old;
char	*new;
{
	int	i, j;

	for (i = j = 0;new[i] && old[i];i++)
		if (strchr (new, old[i]))
			j++;

	if (i >= j * 2)
		return (0);

	printf ("Too similiar.  ");
	return (1);
}

/*
 * a nice mix of characters.
 */

/*ARGSUSED*/
int	simple (old, new)
char	*old;
char	*new;
{
	int	digits = 0;
	int	uppers = 0;
	int	lowers = 0;
	int	others = 0;
	int	size;
	int	i;

	for (i = 0;new[i];i++) {
		if (isdigit (new[i]))
			digits++;
		else if (isupper (new[i]))
			uppers++;
		else if (islower (new[i]))
			lowers++;
		else
			others++;
	}

	/*
	 * The scam is this - a password of only one character type
	 * must be 8 letters long.  Two types, 7, and so on.
	 */

	size = 9;
	if (digits) size--;
	if (uppers) size--;
	if (lowers) size--;
	if (others) size--;

	if (size <= i)
		return 0;

	printf ("Too Simple.  Use a longer password, or a mix of upper\n");
	printf ("and lower case letters and numerics.  ");
	return 1;
}
