/*
 * Copyright 1991, John F. Haugh II
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by John F. Haugh, II
 *      and other contributors.
 * 4. Neither the name of John F. Haugh, II nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JOHN HAUGH AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JOHN HAUGH OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <fcntl.h>
#include "config.h"

#ifndef lint
static char rcsid[] = "$Id: mkrmdir.c,v 1.1 1995/12/16 01:15:45 marekm Exp $";
#endif

#ifdef	NEED_MKDIR
/*
 * mkdir - create a directory
 *
 *	mkdir is provided for systems which do not include the mkdir()
 *	system call.
 */

int
mkdir (dir, mode)
char	*dir;
int	mode;
{
	int	status;

	if (fork ()) {
		while (wait (&status) != -1)
			;

		return status >> 8;
	}
#ifdef	USE_SYSLOG
	closelog ();
#endif
	close (2);
	open ("/dev/null", O_WRONLY);
	umask (0777 & ~ mode);
	execl ("/bin/mkdir", "mkdir", dir, 0);
	_exit (128);
	/*NOTREACHED*/
}
#endif
#ifdef	NEED_RMDIR
/*
 * rmdir - remove a directory
 *
 *	rmdir is provided for systems which do not include the rmdir()
 *	system call.
 */

int
rmdir (dir)
char	*dir;
{
	int	status;

	if (fork ()) {
		while (wait (&status) != -1)
			;

		return status >> 8;
	}
	close (2);
	open ("/dev/null", O_WRONLY);
	execl ("/bin/rmdir", "rmdir", dir, 0);
	_exit (128);
	/*NOTREACHED*/
}
#endif
