/*
 * Copyright 1989 - 1992, John F. Haugh II
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by John F. Haugh, II
 *      and other contributors.
 * 4. Neither the name of John F. Haugh, II nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JOHN HAUGH AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JOHN HAUGH OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include "defines.h"

#ifndef	lint
static char rcsid[] = "$Id: env.c,v 1.1 1995/12/16 01:15:45 marekm Exp $";
#endif

extern	char	**environ;
extern	char	*newenvp[];
extern	int	newenvc;
extern	int	maxenv;

char	*xstrdup ();
void	free ();

static	char	*forbid[] = {
	"HOME",
	"IFS",
	"PATH",
	"SHELL",
#ifdef __linux__
	/* These are for Linux ld.so-1.7.11.  Other systems with shared libs
	   may need this too, but the names may differ.  --marekm */
	"LD_AOUT_PRELOAD",
	"LD_PRELOAD",
	"LD_AOUT_LIBRARY_PATH",
	"LD_LIBRARY_PATH",
	"LD_ELF_PRELOAD",
	"LD_ELF_LIBRARY_PATH",
#endif
	(char *) 0
};

/*
 * addenv - add a new environmental entry
 */

void
addenv (entry)
char	*entry;
{
	char	*cp;
	int	i;
	int	len;

	if ((cp = strchr (entry, '=')))
		len = cp - entry;
	else
		return;

	for (i = 0;i < newenvc;i++)
		if (strncmp (entry, newenvp[i], len) == 0 &&
			(newenvp[i][len] == '=' || newenvp[i][len] == '\0'))
			break;

	if (i == maxenv) {
		puts ("Environment overflow");
		return;
	}
	if (i == newenvc) {
		newenvp[newenvc++] = xstrdup (entry);
	} else {
		free (newenvp[i]);
		newenvp[i] = xstrdup (entry);
	}
}

/*
 * set_env - copy command line arguments into the environment
 */

void
set_env (argc, argv)
int	argc;
char	**argv;
{
	int	i;
	int	n;
	int	noname = 1;
	char	variable[BUFSIZ];
	char	*cp;

	for (i = 0;i < argc;i++) {
		if ((n = strlen (argv[i])) >= BUFSIZ)
			continue;	/* ignore long entries */

		if (! (cp = strchr (argv[i], '='))) {
			(void) strcpy (variable, argv[i]);
		} else {
			(void) strncpy (variable, argv[i], cp - argv[i]);
			variable[cp - argv[i]] = '\0';
		}
		for (n = 0;forbid[n] != (char *) 0;n++)
			if (strcmp (variable, forbid[n]) == 0)
				break;

		if (forbid[n] != (char *) 0) {
			printf ("You may not change $%s\n", variable);
			continue;
		}
		if (cp) {
			addenv (argv[i]);
		} else {
			sprintf(variable, "L%d=", noname++);
			if (strlen(variable) + strlen(argv[i]) <
			    sizeof(variable)) {
				strcat(variable, argv[i]);
				addenv(variable);
			} else {
				printf("$%s too long, ignored\n", variable);
				continue;
			}
		}
	}
}
