#!/usr/bin/perl -w
#
# A perl5 script for interactive addition of user accounts
# using the shadow password suite.
#
# Written by David Nugent <davidn@blaze.net.au>
#
# Prerequisites:
#  Perl 5.001m or later
#  Shadow password suite (specifically, adduser and
#
# 01 Apr 1996	Script written
# 07 Apr 1996	Added logging feature

require 5.001;

my $version='1.01';
my $program='Adduser';
my $rcsdate='07-Apr-1996';
my $log='/var/log/adduser';

print "\n$program: version $version\n";

die "You must be root to run this script." unless $< == 0;

my %add = {};

# Set some reasonable defaults

$add{'GROUP'}='users';
$add{'HOME'}='/home';
$add{'INACTIVE'}='0';
$add{'EXPIRE'}='30';
$add{'SHELL'}='/bin/sh';
$add{'SKEL'}='/etc/skel';

umask(022);

# Then pick up the rest from useradd -D

if (open(CONFIG,'/etc/default/useradd')) {
	while (<CONFIG>) {
		chomp;
		if (/([A-Z]+)=(.*)$/) {
			$add{$1}=$2;
		}
	}
	close CONFIG;
}

while (1) {
	my $switches = "-m -k $add{'SKEL'}";
	my $logname = prompt("\nNew user login name");
	last unless $logname;
	if (getpwnam($logname)) {
		print "That login name is already in use. Choose another.\n";
		next;
	}
	my $uid = prompt("User id", nextuid());
	if (getpwuid($uid)) {
		my $res=substr(prompt("This userid is already in use - Ok", "n"),0,1);
		next unless $res eq 'y' or $res eq 'Y';
		$switches .= ' -o';
	}
	$switches .= " -u $uid";
	my $comment = prompt("User's name");
	next unless $comment;
	$switches .= " -c \"$comment\"";
  getgroup:
	my $group = prompt("Group", $add{'GROUP'});
	next unless $group;
	if (!getgrnam($group) && !getgrgid($group)) {
		print "That group does not exist\n";
		goto getgroup;
	}
	$switches .= " -g $group";
	my $home = prompt("Home directory", $add{'HOME'} . "/$logname");
	$switches .= " -d $home";
  getshell:
	my $shell = prompt("Login shell", $add{'SHELL'});
	my $shellok = 1;
	if (open(SHELLS, '/etc/shells')) {
		$shellok = 0;
		while (<SHELLS>) {
			chomp;
			$shellok = 1 if $shell eq $_;
		}
		close SHELLS;
		if (!$shellok) {
			my $res = substr(prompt("'$shell' is not listed in /etc/shells. Ok",'n'), 0, 1);
			goto getshell unless $res eq 'y' or $res eq 'Y';
		}
	}
	$switches .= " -s $shell";
	$switches .= " -e $add{'EXPIRE'}" if $add{'EXPIRE'};
	print "\n----- NEW ACCOUNT DETAILS TO BE ADDED -----\n\n";
	print "Account: $logname    [ $uid / $group ]\n";
	print "   Name: $comment\n";
	print "   Home: $home\n";
	print "  Shell: $shell\n\n";
	my $res = substr(prompt("Ok to proceed?", 'n'), 0, 1);
	next unless $res eq 'y' or $res eq 'Y';
	my $rc=system("useradd $switches $logname");
	if ($rc == '0') {
		if (open(ADDLOG, ">>$log")) {
			my $tm = localtime time;
			$tm .= sprintf(" Account %s id=%s gr=%s '%s' created by %s",
				$logname, $uid, $group, $comment, $ENV{'USER'});
			print ADDLOG "$tm\n";
			close ADDLOG
			}
		print "Account successfully added.\n";
		print "You must now enter a password for this account.\n";
		system("passwd $logname");
	}
	print "\nPress ENTER to quit adduser.\n";
}

print "Adduser done.\n";
exit 0;

sub prompt {
	my ($quest,$def)=@_;
	$quest .= ' [' . $def . ']' if $def;
	print "$quest: ";
	my $res = <STDIN>;
	chomp $res;
	$res = $def if $def && !$res;
	return $res;
}

sub nextuid {
	my $nextid=0;
	setpwent();
	while (1) {
		my ($name,$pwd,$uid,$gid,$gid,$quota,$comment,$gcos,$dir,$shell)
			=getpwent;
		last unless defined $name;
		$nextid=int($uid + 1) unless ($nextid > $uid) or ($uid > 32767);
	}
	endpwent();
	$nextid=100 unless $nextid;
	return $nextid;
}

__END__
