/*

  scsi_admin: scsi.c

  Copyright 2001, 2002, 2005, 2007 Kadir A. Mueller <kadir.mueller@theflatnet.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#include "global.h"
#define IN_SCSI_ADMIN_SCSI_C
#include "scsi.h"


extern int bus, id, lun, chan, type;
extern char wide, wide32, syncneg, linked, cmdque, removable, sftre, pq, devtypemod,
	isovers, ecmavers, ansivers, multip, mchngr, reladr, ackreqq, addr16,
	addr32, enclosure;
extern int sectors, sectorsize;
extern char vendor[9], model[17], revision[5], serial[9];
extern int fd;
extern char devicepath[PATH_MAX], blockdevpath[PATH_MAX], chardevpath[PATH_MAX], gendevpath[PATH_MAX];
extern long uid;
extern int sgversion;
extern int added;
extern char *ownname;




int scsi_format_unit()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_format_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_format_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_FORMAT_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_doorlock()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_doorlock_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_doorlock_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_doorunlock()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_doorunlock_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_doorunlock_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_stop_unit()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_stop_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_stop_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_start_unit()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_start_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_start_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_test_unit_ready()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_tur_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_tur_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return ioctl(fd, SG_IO, &sg_io);
}

int scsi_inquiry()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_inquiry_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_FROM_DEV;
	sg_io.dxfer_len=SCSI_INQUIRY_REPLY_LEN;
	sg_io.dxferp=scsi_inquiry_buffer;
	sg_io.cmdp=scsi_inquiry_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return ioctl(fd, SG_IO, &sg_io);
}

int scsi_read_capacity()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_readcapacity_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_FROM_DEV;
	sg_io.dxfer_len=SCSI_READCAPACITY_REPLY_LEN;
	sg_io.dxferp=scsi_readcapacity_buffer;
	sg_io.cmdp=scsi_readcapacity_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return ioctl(fd, SG_IO, &sg_io);
}

int opendev(char *path)
{
	int fd;

	fd=open(path, O_RDWR);
	if(fd>0)
		return fd;
	else
		if(errno==EACCES)
			printf("%s: %s while opening %s read-write.\n%s: Trying read-only...", ownname, strerror(errno), path, ownname);
	fd=open(path, O_RDONLY);
	if(fd>0)
		printf(" ok, opened read-only.\n");
	else
		if(errno==EACCES) {
			printf(" FATAL: %s.\n", strerror(errno));
			exit(2);
		}
	return fd;
}

void scsi_devinfo()
{
	printf("%s device: %s, SCSI generic device: %s.\n", (strlen(blockdevpath)>0) ? "Block":"Character", (strlen(blockdevpath)>0) ? blockdevpath:chardevpath, gendevpath);
}

int setdevvars(char *devicestr)		/* set device variables as wanted by the   */
{					/* user, say convert $2 to fd, bus, id etc */
	struct sg_scsi_id sg_id;
	int l, occs=0, result=0;
	unsigned int major,minor;
	char *scsi_inquiry_bufferp=scsi_inquiry_buffer;
	char mnt[PATH_MAX], fstype[PATH_MAX], dummy[PATH_MAX], sysfspath[PATH_MAX], link[PATH_MAX];
	FILE *stream;
	DIR *dirp;
	struct dirent *dp;


	for(l=0; l<strlen(devicestr); l++)
		if(devicestr[l]==',')		 /* do we have to convert x,x,x,x to a path? */
			occs++;			/*   (We assume this if 3 ","'s are found)  */

	if(occs==3) {				  /* yepp. */
		sscanf(devicestr, "%d,%d,%d,%d", &bus, &chan, &id, &lun);
		stream=fopen("/proc/mounts", "r");
		if(stream==NULL)
			return -ENOPROCFS;
		strcpy(fstype, "-");
		while((fscanf(stream, "%s %s %s %s %s %s", (char *)&dummy, (char *)&mnt, (char *)&fstype, (char *)&dummy, (char *)&dummy, (char *)&dummy)==6)&&(strcmp(fstype, "sysfs")!=0));
		fclose(stream);
		if(strcmp(fstype, "sysfs")==0) {
			sprintf(sysfspath, "%s/bus/scsi/devices/%d:%d:%d:%d", mnt, bus, chan, id, lun);
			if((dirp=opendir(sysfspath))!=NULL) {
				bzero(devicepath, (size_t)PATH_MAX);
				bzero(chardevpath, (size_t)PATH_MAX);
				bzero(blockdevpath, (size_t)PATH_MAX);
				while((dp=readdir(dirp))!=NULL) {
					if(strncmp(dp->d_name, "block:", 6)==0)
						sprintf(blockdevpath, "/dev/%s", dp->d_name+6);
					if(strcmp(dp->d_name, "tape")==0) {
						bzero(link, (size_t)PATH_MAX);
						sprintf(dummy, "%s/%s", sysfspath, dp->d_name);
						readlink(dummy, link, (size_t)PATH_MAX);
						sprintf(chardevpath, "/dev/%s", strrchr(link, '/')+1);
					}
					if(strcmp(dp->d_name, "generic")==0) {
						bzero(link, (size_t)PATH_MAX);
						sprintf(dummy, "%s/%s", sysfspath, dp->d_name);
						readlink(dummy, link, (size_t)PATH_MAX);
						bzero(devicepath, (size_t)PATH_MAX);
						sprintf(devicepath, "/dev/%s", basename(link));
						strcpy(gendevpath, devicepath);
						sprintf(dummy, "%s/generic/dev", sysfspath);		/* If we're running without udev, we have to do the job. */
						stream=fopen(dummy, "r");				/* If we have a running udevd,  it can't be fast enough, */
						fscanf(stream, "%u:%u", &major, &minor);		/* since it's running only in user space, too.		 */
						fclose(stream);						/* Back in the  good old times (TM),  there was devfs... */
						mknod(devicepath, S_IFCHR, makedev(major, minor));	/* Well, I wonder why no-one thinks that there has to be */
						fd=opendev(devicepath);					/* a consistent way for creating devices in linux.	 */
						if(fd<0)
							return errno;
					}
				}
				closedir(dirp);
			}
			else {
				strcpy(devicepath, sysfspath);
				return -ENODEVICE;
			}
		}
		else
			return -ENOSYSFS;
	}
	else {
		fd=opendev(devicestr);	/* FIXME: This is a real code-copy-mess! */
		if(fd<0)
			return errno;
		
		sscanf(devicestr, "%d,%d,%d,%d", &bus, &chan, &id, &lun);
		stream=fopen("/proc/mounts", "r");
		if(stream==NULL)
			return -ENOPROCFS;
		strcpy(fstype, "-");
		while((fscanf(stream, "%s %s %s %s %s %s", (char *)&dummy, (char *)&mnt, (char *)&fstype, (char *)&dummy, (char *)&dummy, (char *)&dummy)==6)&&(strcmp(fstype, "sysfs")!=0));
		fclose(stream);
		if(strcmp(fstype, "sysfs")==0) {
			sprintf(sysfspath, "%s/block/%s/device", mnt, basename(devicestr));
			if((dirp=opendir(sysfspath))!=NULL) {
				bzero(devicepath, (size_t)PATH_MAX);
				bzero(chardevpath, (size_t)PATH_MAX);
				bzero(blockdevpath, (size_t)PATH_MAX);
				while((dp=readdir(dirp))!=NULL) {
					if(strncmp(dp->d_name, "block:", 6)==0)
						sprintf(blockdevpath, "/dev/%s", dp->d_name+6);
					if(strcmp(dp->d_name, "tape")==0) {
						bzero(link, (size_t)PATH_MAX);
						sprintf(dummy, "%s/%s", sysfspath, dp->d_name);
						readlink(dummy, link, (size_t)PATH_MAX);
						sprintf(chardevpath, "/dev/%s", strrchr(link, '/')+1);
					}
					if(strcmp(dp->d_name, "generic")==0) {
						bzero(link, (size_t)PATH_MAX);
						sprintf(dummy, "%s/%s", sysfspath, dp->d_name);
						readlink(dummy, link, (size_t)PATH_MAX);
						bzero(devicepath, (size_t)PATH_MAX);
						sprintf(devicepath, "/dev/%s", basename(link));
						strcpy(gendevpath, devicepath);
						sprintf(dummy, "%s/generic/dev", sysfspath);		/* If we're running without udev, we have to do the job. */
						stream=fopen(dummy, "r");				/* If we have a running udevd,  it can't be fast enough, */
						fscanf(stream, "%u:%u", &major, &minor);		/* since it's running only in user space, too.		 */
						fclose(stream);						/* Back in the  good old times (TM),  there was devfs... */
						mknod(devicepath, S_IFCHR, makedev(major, minor));	/* Well, I wonder why no-one thinks that there has to be */
						fd=opendev(devicepath);					/* a consistent way for creating devices in linux.	 */
						if(fd<0)
							return errno;
					}
				}
				closedir(dirp);
			}
			else {
				strcpy(devicepath, sysfspath);
				return -ENODEVICE;
			}
		}
	}

	strcpy(devicepath, devicestr);

	ioctl(fd, SG_GET_SCSI_ID, &sg_id);
	bus=sg_id.host_no;
	chan=sg_id.channel;
	id=sg_id.scsi_id;
	lun=sg_id.lun;
	type=sg_id.scsi_type;
	ioctl(fd, SG_GET_VERSION_NUM, &sgversion);
	result=scsi_inquiry();
	if(result==0) {
		strncpy(vendor, scsi_inquiry_bufferp+8, 8);
		strncpy(model, scsi_inquiry_bufferp+16, 16);
		strncpy(revision, scsi_inquiry_bufferp+32, 4);
		strncpy(serial, scsi_inquiry_bufferp+36, 8);
		enclosure=scsi_inquiry_bufferp[6]&0x40;
		multip=scsi_inquiry_bufferp[6]&0x10;
		mchngr=scsi_inquiry_bufferp[6]&8;
		ackreqq=scsi_inquiry_bufferp[6]&4;
		addr32=scsi_inquiry_bufferp[6]&2;
		addr16=scsi_inquiry_bufferp[6]&1;
		reladr=scsi_inquiry_bufferp[7]&0x80;
		wide32=scsi_inquiry_bufferp[7]&0x40;
		wide=scsi_inquiry_bufferp[7]&0x20;
		syncneg=scsi_inquiry_bufferp[7]&0x10;
		cmdque=scsi_inquiry_bufferp[7]&2;
		linked=scsi_inquiry_bufferp[7]&8;
		sftre=scsi_inquiry_bufferp[7]&1;
		pq=(scsi_inquiry_bufferp[0]&0xe0)>>5;
		removable=scsi_inquiry_bufferp[1]&0x80;
		devtypemod=scsi_inquiry_bufferp[1]&0x7f;
		isovers=scsi_inquiry_bufferp[2]>>6;
		ecmavers=(scsi_inquiry_bufferp[2]&56)>>3;
		ansivers=scsi_inquiry_bufferp[2]&7;
		result=scsi_read_capacity();
		if(result==0) {
			sectors=1+((scsi_readcapacity_buffer[0]<<24)|
				(scsi_readcapacity_buffer[1]<<16)|
				(scsi_readcapacity_buffer[2]<<8)|
				scsi_readcapacity_buffer[3]);
			sectorsize=(scsi_readcapacity_buffer[4]<<24)|
				(scsi_readcapacity_buffer[5]<<16)|
				(scsi_readcapacity_buffer[6]<<8)|
				scsi_readcapacity_buffer[7];
		}
		return 0;
	}
	return result;
}

