//
// Copyright (C) 1996  Lars Berntzon
//
#include <Updateable.hh>
#include <Selectable.hh>

class DBList;
class CreateColumn;

class DBPanel : public Updateable, Selectable
{
public:
    DBPanel(void);					// Create empty panel.
    DBPanel(Widget topshell, const char *databaseName);	// Create the panel.
    void popup(void);
    void popdown(void);
    virtual void select(const char *key);	// Fetch a database entry.
    virtual void update(void);
    void remove(TextList &entries);
    virtual ~DBPanel(void);

private:
    char *databaseName;			// Copy of the database name.
    DBList *listObject;			// This panels corresponding listbox.
    CreateColumn *createColumnObject;	// Panel for creating columns.
    Widget *widgetList;			// List of widgets.
    char **nameList;			// List of widget names.
    Widget top;				// Top level widget.
    Widget widgetFrame;			// Top frame for column widgets.
    Widget fields;			// Lower frame for column widgets.
    int nFields;			// Number of fields.

    void hdl_done(void);
    void hdl_update(void);
    void hdl_fetch(void);
    void hdl_list(void);
    void remove(void);
    void hdl_clear(void);
    void hdl_create_column(void);

    void create_menus(Widget top);

    static void hdl_x11_done(Widget, XtPointer, XtPointer);
    static void hdl_x11_update(Widget, XtPointer, XtPointer);
    static void hdl_x11_fetch(Widget, XtPointer, XtPointer);
    static void hdl_x11_list(Widget, XtPointer, XtPointer);
    static void hdl_x11_remove(Widget, XtPointer, XtPointer);
    static void hdl_x11_clear(Widget, XtPointer, XtPointer);
    static void hdl_x11_create_column(Widget, XtPointer, XtPointer);

    static Widget create_one_field(SADB &, Widget, const char *);
};
