//
// Copyright (C) 1996  Lars Berntzon
//
#include <Selecter.hh>

//
// Class for handling list boxes.
//
class DBList : public Selecter
{
public:
    DBList(Widget topshell, const char *databaseName, DBPanel *panel);
    void list(const TextList &listOfEntries);
    void popup(void);
    void popdown(void);
    virtual ~DBList(void);

private:
    void remove(void);			// The remove callback.
    void done(void);			// The done callback.

    char **stringArray;			// Array of list box values.
    Widget top;				// Top level widget.
    Widget scrollList;			// The actual list widget.
    Widget viewport;			// The viewport which must be set.
    int count;				// Number of strings.
    char *databaseName;			// Name of database for this list.
    DBPanel *panel;			// Pointer to this lists panel.

    static void hdl_select(Widget, XtPointer, XtPointer);
    static void hdl_remove(Widget, XtPointer, XtPointer);
    static void hdl_done(Widget, XtPointer, XtPointer);
};
