//
// Copyright (C) 1996  Lars Berntzon
//
extern "C" {
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
}

#include <sadblib.hh>
#include <iostream.h>
#include <DBPanel.hh>
#include <DBList.hh>
#include <Selectable.hh>

//
// Create the popup.
//
DBList::DBList(Widget topshell, const char *name, DBPanel *p) :
    stringArray(0),
    top(0),
    scrollList(0),
    viewport(0),
    count(0),
    panel(0)
{
    char topName[MAXNAME];

    // Store pointer to the panel.
    panel = p;

    // The toplevel for list boxes are name <db-name>List
    strcpy(topName, name);
    strcat(topName, "List");

    top = XtCreatePopupShell(
		    topName,			// Name.
		    transientShellWidgetClass,	// Widget class.
		    topshell,			// Parent.
		    NULL,			// Args.
		    0);				// Num args.

    Widget popup = XtCreateManagedWidget(
		    "popup",			// Name.
		    boxWidgetClass,		// Widget class.
		    top,			// Parent.
		    NULL,			// Arguments.
		    0);				// Number of arguments.
    
    XtVaCreateManagedWidget(
		    "listLabel",		// Name.
		    labelWidgetClass,		// Widget class.
		    popup,			// Parent.
		    0);

    viewport = XtVaCreateManagedWidget(
		      "listView",		// Name.
		      viewportWidgetClass,	// Widget class.
		      popup,			// Parent.
		      0);

    scrollList = XtVaCreateManagedWidget(
		      "listList",		// Name.
		      listWidgetClass,		// Widget class.
		      viewport,			// Parent.
		      0);			// Arguments.

    //
    // Allocate a unique string for database name to be used by the
    // callback routine.
    //
    XtAddCallback(scrollList, XtNcallback, DBList::hdl_select, (XtPointer*)this);

    Widget widgetFrame = XtVaCreateManagedWidget(
                      "widgetFrame",                    // Name.
                      boxWidgetClass,           // Widget class.
                      popup,                 // Parent.
                      0);                       // Arguments.

    Widget remove = XtVaCreateManagedWidget(
			  "remove",		// Name.
			  commandWidgetClass,	// Widget class.
			  widgetFrame,		// Parent.
			  NULL);

    XtAddCallback(remove, XtNcallback, DBList::hdl_remove, (XtPointer*)this);

    Widget done = XtVaCreateManagedWidget(
			  "done",		// Name.
			  commandWidgetClass,	// Widget class.
			  widgetFrame,		// Parent.
			  NULL);

    XtAddCallback(done, XtNcallback, DBList::hdl_done, (XtPointer*)this);
}

DBList::~DBList(void)
{
    XtDestroyWidget(top);
}

//
// Get list of entries (that matches) and fill in the list
// widget.
//
void
DBList::list(const TextList &entries)
{
    Pix p;				// Index over field widgets.
    int len;				// Counter over list.

    //
    // Free previous array if it exist.
    //
    if (stringArray) {
	for(len = 0; len < count; len++) {
	    if (stringArray[len]) free(stringArray[len]);
	}
    	free(stringArray);
    	stringArray = 0;
    	count = 0;
    }

    //
    // Create a list of char pointers, one per entry.
    //
    len = entries.length();

    stringArray = (char **)malloc((len + 1) * sizeof (char *));

    for(count = 0, (p = entries.first()); p != 0; count++, (entries.next(p)))
    {
	const char *name = entries(p).name();
	stringArray[count] = strdup(name);
    }
    stringArray[count] = 0;

    XawListChange(scrollList, (char **)stringArray, count, 0, 1);
    XtVaSetValues(viewport, "height", 300, "width", 100, 0);
}

// Popup the database panel.
void
DBList::popup(void)
{
    XtPopup(top, XtGrabNone);
}

//
// Handle select.
//
void
DBList::popdown(void)
{
   XtPopdown(top);
}

void
DBList::remove(void)
{
   int i;
   TextList list;
   for(i = 0; i < count; i++) {
   	list.append(TextEntry(stringArray[i]));
   }
   panel->remove(list);

   //
   // No sense in showing this list any more since all of the
   // entries has been deleted.
   //
   popdown();
}

void
DBList::done(void)
{
   popdown();
}

void
DBList::hdl_select(Widget w, XtPointer appData, XtPointer callData)
{
    XawListReturnStruct *data = (XawListReturnStruct *)callData;
    ((DBList *)appData)->select(data->string);
}

void
DBList::hdl_remove(Widget w, XtPointer appData, XtPointer callData)
{
    ((DBList *)appData)->remove();
}

void
DBList::hdl_done(Widget w, XtPointer appData, XtPointer callData)
{
    ((DBList *)appData)->done();
}

//
// History of changes:
// DBList.cc,v
// Revision 1.6  1996/09/29 20:45:53  lasse
// Added the remove button to the list panel.
//
// Revision 1.5  1996/09/14 18:33:42  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.4  1996/03/21 18:57:58  lasse
// Backup
//
// Revision 1.3  1996/03/12 19:43:19  lasse
// Checking in from remote.
//
// Revision 1.1  1996/01/22  20:17:22  lasse
// Checking in from mobile
//
//
