//
// Copyright (C) 1996  Lars Berntzon
//
// Description:
//	Class for handling the creation of databases.
//
extern "C" {
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
}

#include <sadblib.hh>
#include <iostream.h>
#include <Tokenizer.hh>
#include <xsadb.hh>
#include <DBPanel.hh>
#include <DBList.hh>
#include <DBCreate.hh>
#include <XSADB.hh>

//
// Constructor
//
DBCreate::DBCreate(Widget aTopShell) :
    top(0),
    databaseNameWidget(0),
    descriptionWidget(0),
    topshell(aTopShell)
{
    top = XtCreatePopupShell(
		    "dbCreate",			// Name.
		    transientShellWidgetClass,	// Widget class.
		    topshell,			// Parent.
		    NULL,			// Args.
		    0);				// Num args.

    Widget toplevel = XtCreateManagedWidget(
		    "toplevel",			// Name.
		    boxWidgetClass,		// Widget class.
		    top,			// Parent.
		    NULL,			// Arguments.
		    0);				// Number of arguments.
    
    XtVaCreateManagedWidget(
		    "textLabel",		// Name.
		    labelWidgetClass,		// Widget class.
		    toplevel,			// Parent.
		    0);
    // 
    // And the text.
    //
    databaseNameWidget = XtVaCreateManagedWidget(
			"databaseName",			// Name.
			asciiTextWidgetClass,		// Widget class.
	  		toplevel,			// Parent.
	  		XtNeditType,
	  		XawtextEdit,
	  		NULL);

    XtVaCreateManagedWidget(
		    "descriptionLabel",		// Name.
		    labelWidgetClass,		// Widget class.
		    toplevel,			// Parent.
		    0);

    descriptionWidget = XtVaCreateManagedWidget(
			"description",			// Name.
			asciiTextWidgetClass,		// Widget class.
	  		toplevel,			// Parent.
	  		XtNeditType,
	  		XawtextEdit,
	  		NULL);


    //
    // Create buttons.
    //
    Widget buttons = XtCreateManagedWidget(
		    "buttons",			// Name.
		    boxWidgetClass,		// Widget class.
		    toplevel,			// Parent.
		    NULL,			// Arguments.
		    0);				// Number of arguments.
    
    Widget ok = XtVaCreateManagedWidget(
			  "ok",				// Name.
			  commandWidgetClass,		// Widget class.
			  buttons,			// Parent.
			  NULL);			// Args.
    XtAddCallback(ok, XtNcallback, hdl_ok, (XtPointer *)this);

    Widget cancel = XtVaCreateManagedWidget(
			  "cancel",			// Name.
			  commandWidgetClass,		// Widget class.
			  buttons,			// Parent.
			  NULL);			// Args.
    XtAddCallback(cancel, XtNcallback, hdl_cancel, (XtPointer *)this);

}

//
// Destructor.
//
DBCreate::~DBCreate()
{
}

void
DBCreate::popup(void)
{
    XtPopup(top, XtGrabNone);
}

void
DBCreate::popdown(void)
{
    XtPopdown(top);
}

void
DBCreate::ok(void)
{
    const char *dbName;
    const char *desc;
    int rc;

    XtVaGetValues(databaseNameWidget, "string", &dbName, NULL);
    if (dbName == 0 || dbName[0] == 0) {
    	cout << "No database name specified\n";
	popdown();
	return;
    }

    XtVaGetValues(descriptionWidget, "string", &desc, NULL);
    if (desc == 0 || desc[0] == 0) {
    	cout << "No description specified\n";
	popdown();
	return;
    }

    //
    // Create the empty database.
    //
    rc = SADB::create_database(dbName);
    if (rc != 0) {
    	//HACKMARK: xsadb.message borde det vara.
    	cout << "failed to create database: " << dbName << "\n";
    }

    dbList[dbName].open(dbName);

    SADB &db = dbList[dbName];

    rc = db.store("description.text", "key", desc);
    if (rc != 0) {
    	cout << "failed to store key description\n";
    	popdown();
    	return;
    }

    popdown();
    update();
}

void
DBCreate::cancel(void)
{
    popdown();
}

//
//---------- Beginning of X11 helper routines -----------------
//

void DBCreate::hdl_ok(Widget w, XtPointer appData, XtPointer callData)
{
    ((DBCreate *)appData)->ok();
}

void DBCreate::hdl_cancel(Widget w, XtPointer appData, XtPointer callData)
{
    ((DBCreate *)appData)->cancel();
}

//
// History of changes:
// DBCreate.cc,v
// Revision 1.5  1996/09/14 18:33:42  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.4  1996/03/21 18:57:58  lasse
// Backup
//
// Revision 1.3  1996/03/12 19:43:18  lasse
// Checking in from remote.
//
// Revision 1.1  1996/01/22  20:17:22  lasse
// Checking in from mobile
//
//
