//
// Manage objects in an string indexed array.
//
// Usage:
//
//	Assoc<object type> aarr;
//
//	aarr["string"] = object;
//
//	object = aarr["string"];
//
//	if(aarr.exist("string")) { ... }
//
#include <new.h>

struct AssocElem
{
    AssocElem *next;
    char *name;
    void *data;
};

class AssocBase
{
public:
    exist(const char *text);

protected:
    AssocBase(void);
    void *find(const char *text);
    void *make(const char *text, int size);
    AssocElem *list;
};

template <class T> class Assoc : public AssocBase
{
public:
    T &operator[](const char *text) {		// Return object indexed by string.
    	T *p = (T *) AssocBase::find(text);
    	if (p == 0) {
    	    p = (T*) AssocBase::make(text, sizeof (T));
    	    p = new (p) T;
    	}

    	return *p;
    }

    virtual ~Assoc(void) {
    	AssocElem *p;
    	for(p = list; p != 0; p = p->next)
    	{
    	    delete (T *)p->data;
    	}
    }

private:
};
