//
// Copyright (C) 1995  Lars Berntzon
//
#include <sadblib.hh>
#include <sadist.hh>
#include <iostream.h>

//  G l o b a l   s t u f f .

//////////////////////////////////////////////////////////////////
//		P R O C E S S _ I N P U T
//		-------------------------
// Description:
//	Read input and expand special lines beginning with an
//	percent sign.
//
//////////////////////////////////////////////////////////////////
int
SADist::process_input(istream &in)
{
    char *buf;		// String pointer for reading input file.
    int rc;		// Return code.

    //
    // Read all data, if host is to be skipped, return at once.
    // 
    while(in.gets(&buf) && (skip == 0))
    {
    	// 
    	// Special treatment for lines beginning with an percent sign.
    	//
        if (buf[0] == '%') {
            if (buf[1] == '%') {
            	output << buf + 1 << endl;
            	continue;
            }
            else if (buf[1] == '#') {
            	continue;
            }
	    rc = Tcl_GlobalEval(interp, buf + 1);
	    if (rc != 0) {
	    	return rc;
	    }

        }
        else {
            	output << buf << endl;
        }
    }

    return TCL_OK;
}

//
// History of changes:
// process_input.cc,v
// Revision 1.13  1996/09/14 18:33:36  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.12  1995/09/23  13:46:09  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:23:08  qdtlarb
// THis is version 0.6
//
// Revision 1.11  1995/09/10  20:43:25  lasse
// Added copyright everywhere
//
// Revision 1.10  1995/09/10  19:03:43  lasse
// Corrected removed Log keyword
//
// Revision 1.1.1.1  1995/07/17  07:51:37  qdtlarb
// Original V0_3
//
// Revision 1.7  1995/07/16  13:45:48  lasse
// merged differences
//
// Revision 1.6  1995/06/08  19:20:58  lasse
// backup
//
// Revision 1.5  1995/06/07  20:29:44  lasse
// It seems as i managed to make the SADist object ok.
//
// Revision 1.4  1995/06/06  19:04:12  lasse
// Added comment
//
// Revision 1.3  1995/06/05  12:30:45  lasse
// Backup
//
// Revision 1.2  1995/05/16  12:55:41  lasse
// backup
//
// Revision 1.1  1995/05/13  22:03:34  lasse
// backup
//
// Revision 1.1  1995/05/13  20:28:51  lasse
// backup
//
//
