//
// Copyright (C) 1995  Lars Berntzon
//
#include <sadblib.hh>
#include <sadist.hh>
#include <iostream.h>
#include <time.h>

/* G l o b a l   d e c l a r a t i o n s */

extern "C" {
extern long lrand48(void);
extern void srand48(long);
}

/********************************************************
 * 		P R O C _ S A R A N D 
 *		---------------------
 *
 * Description:
 *	Generate a random integer between <start> and <end>, or select a random
 *	string from arguments. It is possible to specify a seed string. If same
 *	seed string is allways used, the same output will be produced.
 *
 * Usage:
 *	sarand [-s <seed>] -i <low> <high>	   - Random integer in range.
 *	sarand [-s <seed>] -t <text1> <text2> ...  - Print random text.
 *
 * Ident:
 * 	proc_sarand.cc,v 1.6 1996/09/14 18:33:35 lasse Exp
 *
 ***********************************************************/

static int hash_string(const char *str);

int
SADist::proc_sarand(int argc, char **argv)
{
    char val[100];
    int opt_i = 0;
    int opt_t = 0;
    int min = 0;
    int max = 0;
    int range = 0;
    long seed = hash_string(host);

    /*
     * Calculate name of program.
     */
    if ((prog = strrchr(argv[0], '/'))) prog++;
    else prog = argv[0];

    /*
     * Check for enough arguments.
     */
    if (argc < 3) {
	Tcl_SetResult(interp, "sarand: insufficient arguments", 0);
	return TCL_ERROR;
    }

    //
    // Examine options.
    //
    while(argc--, *++argv)
    {
	if (strcmp(*argv, "-i") == 0) {
	    opt_i = 1;
	    if (argc < 3) {
		Tcl_SetResult(interp, "sarand: -i needs two arguments\n", 0);
		return TCL_ERROR;
	    }
	    min = atoi(argv[1]);
	    max = atoi(argv[2]);
	    range = max - min;
	    argv += 2;
	    argc -= 2;
	}
	else if (strcmp(*argv, "-t") == 0) {
	    opt_t = 1;
	    argv++;
	    argc--;
	    break;
	}
	else if (strcmp(*argv, "-s") == 0) {
	    //
	    // Make a hash value of the seed string.
	    //
	    if (argc < 2) {
		Tcl_SetResult(interp, "sarand: -s needs an argument", 0);
		return TCL_ERROR;
	    }
	    seed = hash_string(argv[1]);

	    argv++;
	    argc--;
	}
	else if (argv[0][0] == '-') {
	    Tcl_SetResult(interp, "sarand: unknown option", 0);
	    return TCL_ERROR;
	}
	else {
	    break;
	}
    }

    /*
     * Randomize random generator.
     */
    srand48(seed);

    /*
     * Do the right thing depending of options.
     */
    if (opt_i) {
	if (range < 0) {
	    range = -range;
	    min = max;
	}

	sprintf(val, "%ld", min + (lrand48() % (range + 1)));
	Tcl_SetResult(interp, val, 0);
    }
    else if (opt_t) {
	int range = argc;
	Tcl_SetResult(interp, argv[lrand48() % range], 0);
    }
    else {
	Tcl_SetResult(interp, "sarand: either -i or -t must be specified", 0);
	return TCL_ERROR;
    }

    return TCL_OK;
}

static int
hash_string(const char *str)
{
    int seed = 0;

    for(int i = 0; str[i]; i++) {
	seed += str[i];
    }

    return seed;
}
//
// History of changes:
// proc_sarand.cc,v
// Revision 1.6  1996/09/14 18:33:35  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.5  1996/03/12 19:42:32  lasse
// Checking in from remote.
//
// Revision 1.4  1995/11/18  11:57:48  lasse
// Bugfix with multiple distributions and corrected the sarand to allways
// use hostname as the seed value
//
// Revision 1.3  1995/09/23  13:46:09  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:23:08  qdtlarb
// THis is version 0.6
//
// Revision 1.2  1995/09/10  20:43:24  lasse
// Added copyright everywhere
//
// Revision 1.1  1995/08/31  18:12:26  lasse
// Created
//
// Revision 1.1  1995/08/31  19:58:07  qdtlarb
// Created
//
// Revision 1.1  1995/08/08  09:07:16  qdtlarb
// Created
//
//
