//
// Copyright (C) 1995  Lars Berntzon
//
#include <sadblib.hh>
#include <sadist.hh>
#include <iostream.h>

//////////////////////////////////////////////////////////////////
//		P R O C _ S A D B
//		-----------------
// Description:
//	Read entries from the database.
//
//////////////////////////////////////////////////////////////////
int
SADist::proc_sadb(int argc, char **argv)
{
    Pix i;
    TextList entries;
    SADB db(argv[0]);

    //
    // Shift away routine name.
    //
    argc--, argv++;

    //
    // Make a list of entires which match according to
    // command line arguments.
    //
    db.parse_matching(argc, argv, entries);
    if (db.errno) {
	interp->result = db.errorMessage;
	return TCL_ERROR;
    }

    Tcl_ResetResult(interp);
    for(i = entries.first(); i != 0; entries.next(i))
    {
    	Tcl_AppendElement(interp, (char *)entries(i).name());
    }

    return TCL_OK;
}

//
// History of changes:
// proc_sadb.cc,v
// Revision 1.10  1996/09/14 18:33:35  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.9  1995/11/09  21:21:01  lasse
// To be 0.9
//
// Revision 1.8  1995/09/23  13:46:09  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:23:08  qdtlarb
// THis is version 0.6
//
// Revision 1.7  1995/09/10  20:43:24  lasse
// Added copyright everywhere
//
// Revision 1.6  1995/09/10  19:03:42  lasse
// Corrected removed Log keyword
//
// Revision 1.1.1.1  1995/07/17  07:51:36  qdtlarb
// Original V0_3
//
// Revision 1.4  1995/07/16  13:45:48  lasse
// merged differences
//
// Revision 1.3  1995/06/09  21:37:04  lasse
// Now both sadbcmd and sadist seems to work with G++ DLList classes
//
// Revision 1.2  1995/06/07  20:29:44  lasse
// It seems as i managed to make the SADist object ok.
//
// Revision 1.1  1995/05/13  20:12:01  lasse
// backup
//
//
