//
// Copyright (C) 1995  Lars Berntzon
//
#include <sadblib.hh>
#include <sadist.hh>
#include <iostream.h>
#include <fstream.h>

//
// List of supported file CM archives.
//
//Archive::fileTypes[] = {
//    { "RCS/%s,v", rcs_open},	// RCS Archive.
//    { "SCCS/s.%s", sccs_open},	// SCCS Archive.
//    { "CVS/", cvs_open},	// CVS Archive (further test must be performed in the opening).
//    { 0, 0}			// Terminate list.
//};


//////////////////////////////////////////////////////////////////
//		A R C H I V E
//		-------------
//
// Description:
//	File class for version controlled files.
//
//////////////////////////////////////////////////////////////////

//
// Constructor.
//
Archive::Archive(void) :
    rep(0)
{
}

int
Archive::open(Tcl_Interp *interp, const char *fileName)
{

    //
    // Check which type of CM archive to use.
    //
    // HACKMARK: support more types of files like CVS, RCS and SCCS.
    if (access(fileName, F_OK) == 0) {
    	rep = new FileRep(fileName);
    	if (rep == 0) {
	    Tcl_SetResult(interp, "out of memory", 0);
	    return TCL_ERROR;
    	}
    }
    if (rep == 0) {
    	Tcl_AppendResult(interp, fileName, ": failed to open file", 0);
    	return TCL_ERROR;
    }
 
    return TCL_OK;
}

istream &
Archive::stream(void)
{
    return rep->stream();
}

Archive::~Archive()
{
    delete rep;
}

//
// ArchiveRep
//
ArchiveRep::~ArchiveRep()
{
}

//
// FileRep
//
FileRep::FileRep(const char *fileName) :
    s(fileName)
{
}

istream &
FileRep::stream(void)
{
    return s;
}

FileRep::~FileRep(void)
{
    s.close();
}

//
// History of changes:
// Archive.cc,v
// Revision 1.8  1996/09/14 18:33:33  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.7  1995/09/23  13:46:07  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:23:06  qdtlarb
// THis is version 0.6
//
// Revision 1.6  1995/09/10  20:43:23  lasse
// Added copyright everywhere
//
// Revision 1.5  1995/09/10  19:03:41  lasse
// Corrected removed Log keyword
//
// Revision 1.1.1.1  1995/07/17  07:51:35  qdtlarb
// Original V0_3
//
// Revision 1.3  1995/06/06  17:55:33  lasse
// backup
//
// Revision 1.2  1995/06/05  12:30:45  lasse
// Backup
//
//
