//
// Copyright (C) 1995  Lars Berntzon
//
extern "C" {
#include <string.h>
}
#include <Tokenizer.hh>

//
// M e t h o d s .
//
Tokenizer::Tokenizer(void) : nextChar(0)
{
}

char *
Tokenizer::start(char *str, const char *sep)
{
    char *ret;

    nextChar = str;
    if (str == NULL) {
        return NULL;
    }

    // First skip all separator characters.
    for(; *nextChar; nextChar++) {
    	if (!strchr(sep, *nextChar)) {
    	    break;
    	}
    }

    ret = nextChar;

    // Find first separator character.
    for(; *nextChar; nextChar++) {
    	if (strchr(sep, *nextChar)) {
    	    break;
    	}
    }

    // Null all separator characters.
    for(; *nextChar; nextChar++) {
    	if (!strchr(sep, *nextChar)) {
    	    break;
    	}
    	*nextChar = 0;
    }

    // Check if end of string.
    if (*nextChar == 0) {
       nextChar = 0;
    }

    return ret;
}

char *
Tokenizer::next(const char *sep)
{
    return start(nextChar, sep);
}

#ifdef STANDALONE
main()
{
    char *p;
    char str[] = ";Hejsan;hoppsan;;nissan";
    Tokenizer val;
    for(p = val.start(str, ";"); p; p = val.next(";"))
    {
    	cout << p << endl;
    }

}
#endif

//
// History of changes:
// Tokenizer.cc,v
// Revision 1.1  1996/01/22 20:17:21  lasse
// Checking in from mobile
//
//
