#include <iostream.h>
#include <stdlib.h> 
#include <sadbconfig.hh>
#include <List.hh>
#ifdef HAVE_STRING_H
#include <string.h>
#endif

//
// Copyright (C) 1995  Lars Berntzon
//
//
// E n t r y .
//
Entry::Entry(const char *n)
{
    if (n != 0) {
	pName = strdup(n);
    }
    else {
    	pName = 0;
    }
}

Entry::Entry(const Entry &e)
{
    if (e.pName) {
	pName = strdup(e.pName);
    }
    else {
    	pName = 0;
    }
}

Entry &
Entry::operator= (const Entry &e)
{
    if (pName != 0) {
    	free(pName);
    	pName = 0;
    }
    if (e.pName != 0) {
	pName = strdup(e.pName);
    }

    return *this;
}

const char *
Entry::name(void) const
{
    return pName;
}

Entry::~Entry()
{
    if (pName) {
    	free(pName);
    }
}


//
// T e x t E n t r y .
//
TextEntry::TextEntry() : Entry(), txt(0)
{
}

TextEntry::TextEntry(const char *name, const char *value) :
    Entry(name)
{
    txt = 0;
    if (value) {
    	txt = strdup(value);
    }
}

TextEntry::TextEntry(const TextEntry &e) :
    Entry(e)
{
    if (e.txt != 0) {
    	txt = strdup(e.txt);
    }
    else {
    	txt = 0;
    }
}

TextEntry &
TextEntry::operator=(const TextEntry &e)
{
    Entry::operator=(e);

    if (txt != 0) {
    	free(txt);
    	txt = 0;
    }

    if (e.txt != 0) {
    	txt = strdup(e.txt);
    }

    return *this;
}

const char * 
TextEntry::text(void)
{
   return txt;
}

TextEntry::~TextEntry()
{
    if (txt) {
    	free(txt);
    }
}


//
// L i s t E n t r y .
//
ListEntry::ListEntry(void) : Entry(), pList()
{
}

ListEntry::ListEntry(const char *name) : Entry(name), pList()
{
}

ListEntry::ListEntry(const ListEntry &e) : Entry(e), pList(e.pList) 
{
}

ListEntry &
ListEntry::operator=(const ListEntry &e)
{
    Entry::operator=(e);
    pList = e.pList;
    return *this;
}

TextList & 
ListEntry::list(void)
{
   return pList;
}

ListEntry::~ListEntry()
{
}

//
// History of changes:
// List.cc,v
// Revision 1.1.1.1  1995/07/17  07:51:30  qdtlarb
// Original V0_3
//
// Revision 1.15  1995/07/05  19:03:42  lasse
// backup
//
// Revision 1.14  1995/06/09  21:12:21  lasse
// backup
//
// Revision 1.13  1995/06/09  17:13:52  lasse
// Started to convert to use libg++ DLList, sadblib seems ok. sadbcmd
// compiles but does not work.
//
// Revision 1.5  1995/05/12  13:42:05  lasse
// backup
//
// Revision 1.4  1995/05/09  21:49:51  lasse
// Backup
//
// Revision 1.3  1995/05/09  19:59:28  lasse
// Ok, now List and Entry compiles but i guess its more to it.
//
// Revision 1.2  1995/05/09  19:41:56  lasse
// backup
//
// Revision 1.1  1995/05/09  19:25:16  lasse
// Backup
//
//


#if 0
//
// HACKMARK: only for debugging.
//
static int indent = 0;

void print_TextList(TextList &list)
{
    Pix i;
    for(i = list.first(); i != 0; list.next(i))
    {
        cout << list(i).name();
        if (list(i).text() != 0) {
           cout << "=" << list(i).text();
        }
        cout << endl;
    }
}
#endif

//
// History of changes:
// List.cc,v
// Revision 1.20  1996/09/14 18:33:31  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.19  1995/09/23  13:46:04  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:23:00  qdtlarb
// THis is version 0.6
//
// Revision 1.18  1995/09/10  20:43:21  lasse
// Added copyright everywhere
//
// Revision 1.17  1995/09/10  19:03:39  lasse
// Corrected removed Log keyword
//
//
