#include <sadblib.hh>
#include <sadbcmd.hh>
#ifdef HAVE_STRING_H
#include <string.h>
#endif // HAVE_STRING_H
//
// Copyright (C) 1995  Lars Berntzon
//
/******************************************************************
 *		S H E L L _ E S C A P E
 *		-----------------------
 * Description:
 *	Convert a string so it wont disturb the shell, eg.
 *	make ";" to be "\;"
 *
 ******************************************************************/
char *
shell_escape(const char *str)
{
    static char *special = " \t$\\;[](){}`*?\"'";
    static char buf[MAXNAME];
    char *p;

    if (*str == 0) {
    	strcpy(buf, "\"\"");
    }
    else {
	for(p = buf; *str; str++)
	{
	    if (strchr(special, *str)) {
		*p++ = '\\';
	    }
	    *p++ = *str;
	}
	*p = 0;
    }


    return buf;
}

//
// History of changes:
// shell_escape.cc,v
// Revision 1.8  1996/09/14 18:33:28  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.7  1995/09/23  13:46:03  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:22:59  qdtlarb
// THis is version 0.6
//
// Revision 1.6  1995/09/10  20:43:16  lasse
// Added copyright everywhere
//
// Revision 1.5  1995/09/10  19:03:37  lasse
// Corrected removed Log keyword
//
// Revision 1.2  1995/07/24  11:48:54  qdtlarb
// Added () and {} as shell special characters
//
// Revision 1.1.1.1  1995/07/17  07:51:28  qdtlarb
// Original V0_3
//
// Revision 1.3  1995/07/16  13:42:09  lasse
// removed merging differences
//
// Revision 1.2  1995/05/12  13:36:39  lasse
// backup
//
// Revision 1.1.1.1  1995/05/02  22:18:19  lasse
// First checkin into cvs
//
// Revision 1.2  1995/04/08  23:39:38  lasse
// Null strings are now ok with -shell
//
// Revision 1.1  1995/04/08  22:01:15  lasse
// Added -shell option to escape shell characters and turn column
// names into uppercase allways.
//
// Revision 1.4  1995/04/08  21:18:32  lasse
// Now it seems to work with multiple shows, continuing to add uppercase
// column name and adding shell escapes.
//
// Revision 1.3  1995/04/08  12:19:12  lasse
// Before adding -show all
//
// Revision 1.2  1995/04/08  11:11:32  lasse
// backup
//
// Revision 1.1  1995/04/08  11:02:29  lasse
// Splitted into several files.
//
