#include <sadblib.hh>
#include <sadbcmd.hh>
//
// Copyright (C) 1995  Lars Berntzon
//
void
sadb_usage(SADB &database)
{
    TextList columns;
    Pix col;
    int i = 0;
    const char *name;
    const char *value;

    fprintf(stderr, "usage: %s [-options] [machine ...]\n", prog);
    fprintf(stderr, "where option is:\n");
    fprintf(stderr, "   -<column> <match> - list machines where match\n");
    fprintf(stderr, "   -show <column>    - show data in column\n");
    fprintf(stderr, "   -show all         - show data in all columns\n");
    fprintf(stderr, "   -u                - sort unique\n");
    fprintf(stderr, "   -shell            - produce shell syntax output\n");
    fprintf(stderr, "\n");

    /*
     * Examine which columns exists.
     */
    columns = database.list_columns();
    if (!columns.empty()) {
	fprintf(stderr, "Following columns exists:\n");
	for(i = 0, col = columns.first(); col != 0; columns.next(col))
	{
	    name = columns(col).name();

	    //
	    // Skip the _date columns, they are mostly internal.
	    //
	    if (strcmp(name+ strlen(name) - 5, "_date") == 0) {
		continue;
	    }
            value = database.fetch("description.text", name);
            if (value == 0) {
            	value = "?";
            }
	    fprintf(stderr, "%-15s: %s\n", name, value);
	}
    }

    exit(1);
}
//
// History of changes:
// sadb_usage.cc,v
// Revision 1.12  1996/09/14 18:33:27  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.11  1995/10/16  22:51:45  lasse
// bckup
//
// Revision 1.10  1995/09/23  13:46:02  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:22:58  qdtlarb
// THis is version 0.6
//
// Revision 1.9  1995/09/10  21:17:19  lasse
// Print description text for all columns in usage.
//
// Revision 1.8  1995/09/10  20:57:48  lasse
// Don't show _date columns.
//
// Revision 1.7  1995/09/10  20:43:16  lasse
// Added copyright everywhere
//
// Revision 1.6  1995/09/10  19:03:37  lasse
// Corrected removed Log keyword
//
// Revision 1.2  1995/07/24  12:27:32  qdtlarb
// Less columns in help text
//
// Revision 1.1.1.1  1995/07/17  07:51:28  qdtlarb
// Original V0_3
//
// Revision 1.4  1995/07/16  13:42:09  lasse
// removed merging differences
//
// Revision 1.3  1995/06/09  17:13:51  lasse
// Started to convert to use libg++ DLList, sadblib seems ok. sadbcmd
// compiles but does not work.
//
// Revision 1.2  1995/05/12  13:36:38  lasse
// backup
//
// Revision 1.1.1.1  1995/05/02  22:18:19  lasse
// First checkin into cvs
//
// Revision 1.5  1995/04/08  22:01:14  lasse
// Added -shell option to escape shell characters and turn column
// names into uppercase allways.
//
// Revision 1.4  1995/04/08  21:18:32  lasse
// Now it seems to work with multiple shows, continuing to add uppercase
// column name and adding shell escapes.
//
// Revision 1.3  1995/04/08  12:19:13  lasse
// Before adding -show all
//
// Revision 1.2  1995/04/08  11:11:33  lasse
// backup
//
// Revision 1.1  1995/04/08  11:02:30  lasse
// Splitted into several files.
//
//
