//
// Copyright (C) 1995  Lars Berntzon
//
#ifndef _SADBLIB_HH
#define _SADBLIB_HH
//******************************************************************
//*		S A D B L I B . H
//*		-----------------
//* Description:
//*	Major header file for the sadb library.
//*
//******************************************************************

#include <sadbconfig.hh>

// I n c l u d e s .

extern "C" {
#include <stdio.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif

#ifndef DB_OF_CHOICE
#ifdef HAVE_GDBM_H
#include <gdbm.h>
#define DB_OF_CHOICE GDBM
#define USE_GDBM
#endif
#endif

#ifndef DB_OF_CHOICE
#ifdef HAVE_NDBM_H
#include <ndbm.h>
#define DB_OF_CHOICE NDBM
#define USE_NDBM
#endif
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

// HACKMARK: USE CONFIG TO CHECK UNISTD.H.
#include <unistd.h>

}

//  D e f i n e s .
#define SADBDIR "SADBDIR"		// Environment variable to use for database.
#define SAHOMEENV "SAHOME"		// Environment variable to use for database.
#define SABINDIR "SABINDIR"		// Top directory for satools binaries.

#define SADISTHOMEENV "SADISTHOME"	// Default sadist environment

#define MAXNAME	  1024			// Length of temporary strings.
					// HACKMARK: should be dynamically allocated.  

//
// Define which max length of a path to use.
//
#ifndef PATH_MAX
#ifdef _POSIX_PATH_MAX
#define PATH_MAX _POSIX_PATH_MAX
#else
#define PATH_MAX 1024
#endif
#endif

const int OK = 0;

#define BUG(msg) {fprintf(stderr, "BUG: file %s line %d: %s\n", __FILE__, __LINE__, msg); exit(1);}

//
// Classes of SATOOLS
//
#include <List.hh>
#include <SADB.hh>
#include <DB.hh>

#endif // _SADBLIB_HH.

//
// History:
// sadblib.hh,v
// Revision 1.20  1996/09/21 23:32:08  lasse
// Modified the way databases are choosen.
//
// Revision 1.19  1996/09/14 18:33:25  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.18  1996/03/12 19:42:25  lasse
// Checking in from remote.
//
// Revision 1.17  1996/01/22  20:17:20  lasse
// Checking in from mobile
//
// Revision 1.16  1995/09/23  13:46:01  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:22:57  qdtlarb
// THis is version 0.6
//
// Revision 1.15  1995/09/10  20:43:10  lasse
// Added copyright everywhere
//
// Revision 1.14  1995/09/10  19:20:23  lasse
// Corrected comments
//
// Revision 1.13  1995/09/10  19:03:36  lasse
// Corrected removed Log keyword
//
//
//
