//
// Copyright (C) 1995  Lars Berntzon
//
#ifndef _SADB_HH
#define _SADB_HH
#include <tcl.h>


//
// The SADB main class.
//
class SADB {
public:
    SADB(void);
    SADB(const char *dbName);
    int  open(const char *name);
    int  column_exist(const char *name);
    ListList extract_columns(TextList &columns, TextList &entries);
    static TextList list_databases(void);
    TextList list_columns(void);
    TextList list_entries(void);
    int match(const char *db, const char *str,TextList &entries, TextList &ret);
    const char *fetch(const char *key, const char *column);
    int store(const char *key, const char *column, const char *value);
    int remove(const char *key, const char *column);
    int parse_matching(int argc, char **argv, TextList &entries);
    static int create_database(const char *databaseName);
    static int database_directory(const char *databaseName, char *dir);
    static int base_directory(char *dir);
    static int Tcl_AppInit(Tcl_Interp *interp);
    ~SADB();

    char dbDirectory[PATH_MAX];
    static char errorMessage[MAXNAME];
    static int errno;

private:
    static int proc_sadb(ClientData data, Tcl_Interp *interp, int argc, char **argv);
};
#endif // _SADB_HH

//
// History:
// SADB.hh,v
// Revision 1.20  1996/09/14 18:33:24  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.19  1996/03/12 19:42:25  lasse
// Checking in from remote.
//
// Revision 1.17  1996/01/22  20:17:19  lasse
// Checking in from mobile
//
// Revision 1.16  1995/11/09  21:20:59  lasse
// To be 0.9
//
// Revision 1.15  1995/11/06  20:53:03  lasse
// Now xsadb can list entries that matches
//
// Revision 1.14  1995/10/22  22:18:01  lasse
// Backup
//
// Revision 1.13  1995/10/22  12:33:23  lasse
// Backup
//
// Revision 1.12  1995/09/23  13:46:01  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:22:57  qdtlarb
// THis is version 0.6
//
// Revision 1.11  1995/09/10  20:43:10  lasse
// Added copyright everywhere
//
// Revision 1.10  1995/09/10  19:20:23  lasse
// Corrected comments
//
// Revision 1.9  1995/09/10  19:03:36  lasse
// Corrected removed Log keyword
// 
//
//
