//
// Copyright (C) 1995  Lars Berntzon
//
#ifndef _LIST_HH
#define _LIST_HH
#include <DLList.h>


//////////////////////////////////////////////////////////////////
//		E N T R Y
//		---------
// Description:
//	A base class entry which only contain its name.
//
//////////////////////////////////////////////////////////////////
class Entry {
public:
    const char *name() const;		// Return name of Entry.

protected:
    Entry(const char *name = 0);	// Constructor.
    Entry(const Entry &e);		// Copy constructor.
    Entry& operator=(const Entry &e);	// Assignment.
    virtual ~Entry();			// Destructor.

    char *pName;

private:
};


//////////////////////////////////////////////////////////////////
//		T E X T E N T R Y
//		-----------------
// Description:
//	A List entry which contain exept its name a value.
//
//////////////////////////////////////////////////////////////////
class TextEntry : public Entry {
public:
    TextEntry();					// Empty constructor.
    TextEntry(const TextEntry &e);			// Copy constructor.
    TextEntry(const char *name, const char *value = 0);	// Constructor.
    TextEntry& operator=(const TextEntry &e);		// Assignment operator.
    const char *text(void);				// Return value of entry.

    virtual ~TextEntry(void);				// Destructor.

private:
    char *txt;
};

typedef DLList<TextEntry> TextList;


//////////////////////////////////////////////////////////////////
//		L I S T E N T R Y
//		-----------------
// Description:
//	A List entry which contain a sub list.
//
//////////////////////////////////////////////////////////////////
class ListEntry : public Entry {
public:
    ListEntry();				// Empty constructor.
    ListEntry(const ListEntry &e);		// Copy constructor.
    ListEntry(const char *name);		// Constructor.
    ListEntry& operator=(const ListEntry &e);	// Assignment operator.
    TextList& list(void);

    virtual ~ListEntry(void);			// Destructor.

private:
    TextList pList;
};

typedef DLList<ListEntry> ListList;

#endif // _LIST_HH
//
// History:
// List.hh,v
// Revision 1.12  1996/09/14 18:33:24  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.11  1995/09/23  13:46:01  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:22:56  qdtlarb
// THis is version 0.6
//
// Revision 1.10  1995/09/10  20:43:10  lasse
// Added copyright everywhere
//
// Revision 1.9  1995/09/10  19:20:23  lasse
// Corrected comments
//
// Revision 1.8  1995/09/10  19:03:36  lasse
// Corrected removed Log keyword
// 
//
