//
// Copyright (C) 1995  Lars Berntzon
//
#ifndef _DB_HH
#define _DB_HH
//
// Generic database class.
//
class DB
{
public:
    enum Mode {insert_t, replace_t};			// Type of store.
    DB(void);						// Constructor.
    virtual ~DB();					// Destructor.
    virtual const char *fetch(const char *key) = 0;	// Fetch data.
    virtual const char *firstkey(void) = 0;		// Get first key in database.
    virtual const char *nextkey(void) = 0;		// Get next key in database.
    virtual int store(const char *key, const char *val, Mode mode) = 0; // Store value.
    virtual int remove(const char *key) = 0;		// Remove value.
    int ok(void);					// Return true if ok.

protected:
    static DB *first;					// Global list of databases.

    DB *next;						// Next database in global list
    int error;						// Flag if error.
};

#ifdef USE_NDBM
//
// NDBM database.
//
class NDBM : public DB
{
public:
    NDBM(const char *name, int mode = 0);	// Constructor.
    ~NDBM();					// Destructor.
    const char *fetch(const char *key);		// Fetch data.
    const char *firstkey(void);			// Get first key in database.
    const char *nextkey(void);			// Get next key in database.
    int store(const char *key, const char *val, Mode mode); // Store value.
    int remove(const char *key);		// Remove value.

private:
    void store_in_buf(datum);			// Store datum as null terminated string.

    DBM *dbmData;				// NDBM internal data.
    char *buf;					// Internal buffer for returning data.
    int bufLen;					// Total length of allocated buf.
};
#endif // USE_NDBM

#ifdef USE_GDBM
//
// GDBM database.
//
#include <gdbm.h>
class GDBM : public DB
{
public:
    GDBM(const char *name, int mode = 0);	// Constructor.
    ~GDBM();					// Destructor.
    const char *fetch(const char *key);		// Fetch data.
    const char *firstkey(void);			// Get first key in database.
    const char *nextkey(void);			// Get next key in database.
    int store(const char *key, const char *val, Mode mode); // Store value.
    int remove(const char *key);		// Remove value.

private:
    void store_in_buf(datum);			// Store datum as null terminated string.

    GDBM_FILE dbf;				// NDBM internal data.
    char *buf;					// Internal buffer for returning data.
    int bufLen;					// Total length of allocated buf.
    datum prev_key;				// Used for indexing.
};
#endif // USE_GDBM

#if defined(sun) && !defined(svr4) && !defined(__svr4__)
#define DATUMREF &
#else
#define DATUMREF
#endif

#endif // _DB_HH

//
// History:
// DB.hh,v
// Revision 1.14  1996/09/14 18:33:24  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.13  1995/10/22  22:18:00  lasse
// Backup
//
// Revision 1.12  1995/09/23  13:46:00  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:22:56  qdtlarb
// THis is version 0.6
//
// Revision 1.11  1995/09/10  20:43:10  lasse
// Added copyright everywhere
//
// Revision 1.10  1995/09/10  19:20:22  lasse
// Corrected comments
//
// Revision 1.9  1995/09/10  19:03:35  lasse
// Corrected removed Log keyword
// 
//
//
