#!/bin/sh
# /usr/local/bin/rt.sh - super(1) filter for rt
#
# $Id: rt.sh,v 1.6 1999/11/06 11:36:18 fedorov Exp $

RT='/usr/local/bin/rt'

function Usage()
{
    echo 'Usage: rt.sh {RR|FIFO} [rt-options] command [args]' 1>&2
    exit 1
}

if [ "$#" -lt 1 ]; then Usage; fi

PRIV=$1
shift

if [ $PRIV != 'RR'  -a  $PRIV != 'FIFO' ]; then Usage; fi

while getopts 'r::f::i::os::S::hv' opt $*
  do
	if [ "$opt" = '?'  -o  $opt = ':' ]
	then
		$RT -h
		exit 1
	fi

	if [ $opt = 'S'  -o  $opt = 'o' ]
	then
		echo "-S option not allowed for user" 1>&2
		exit 2
	fi

	if [ $opt = 'f'  -a  $PRIV = 'RR' ]
	then
		echo "$PRIV privilege level insufficient for -$opt option" 1>&2
		exit 2
	fi

	if [ $opt = 'r'  -o  $opt = 'f'  -o  $opt = 'i' ]
	then
		if [ $OPTARG -gt 10 ]
		then
			echo "priority $OPTARG not allowed for user" 1>&2
			exit 2
		fi
	fi
  done

exec $RT $*

