#include "header.h"
#ifndef INET_ADDRSTRLEN
#define INET_ADDRSTRLEN         16
#endif
const char *inet_ntop(int, const void*,char*,size_t);

void main(int argc, char *argv[])
{
  struct hostent *hname;
  char *name;
  char **incr;
  char **aliases;
  char textaddress[INET_ADDRSTRLEN];
  char *newlocation[6];
  int i=0;
  name = argv[1];
  
  if ((hname = gethostbyname(name)) == NULL) {
    printf("Error resolving hostname\n");
    exit(1);
  }
  
  printf("the canonical name of %s is %s\n",name,hname->h_name);
  for (aliases = hname->h_aliases; *aliases != NULL; aliases++)
    printf("Got an alias of: %s\n",*aliases);
  for (incr = hname->h_addr_list;*incr != NULL;incr++) {
    printf("Got an address of %s\n",inet_ntop(hname->h_addrtype,*incr,textaddress,INET_ADDRSTRLEN));
    newlocation[i] = malloc(INET_ADDRSTRLEN);
    if (strncpy(newlocation[i],inet_ntop(hname->h_addrtype,*incr,textaddress,INET_ADDRSTRLEN),INET_ADDRSTRLEN) == NULL) {
      printf("Bad news for the strncpy!\n");
    }
    i++;
    
  }
  
}
/* include inet_ntop */
const char *
inet_ntop(int family, const void *addrptr, char *strptr, size_t len)
{
        const u_char *p = (const u_char *) addrptr;
	
        if (family == AF_INET) {
                char    temp[INET_ADDRSTRLEN];

		/*                snprintf(temp, sizeof(temp), "%d.%d.%d.%d",
                                 (p[0]), p[1], (p[2]), p[3]);
				 */
		sprintf(temp,"%d.%d.%d.%d",(p[0]), p[1], (p[2]), p[3]);
                if (strlen(temp) >= len) {
                        errno = ENOSPC;
                        return (NULL);
                }
                strcpy(strptr, temp);
                return (strptr);
        }
        errno = EAFNOSUPPORT;
        return (NULL);
}
/* end inet_ntop */
