#ifndef NODE_H
#define NODE_H

#ifndef HEADER_H
#include "header.h"
#endif /* HEADER_H */
#ifndef IO_H
#include "io.h"
#endif /* IO_H */

#define SIZE_ORDER 11 /* Max number of digits + 1 in a file size field */
#define MODE_LENGTH 7 /* Octal Digits in mode + 1 */
#define FINISH_LENGTH 8 /* Max number of digits + 1 in a "finish" string */
#define LINK_LENGTH 2 /* "S", "H" or "R", +1 for Symlink, Hardlink, or Regular */
#define UID_LENGTH 6 /* Assuming max uid = 99,999 */
#define GID_LENGTH 6 /* Assuming max gid = 99,999 */
#define TIME_LENGTH 11 /* Max number of digits + 1 in a long */
#define MAJOR_LENGTH 4 /* Length of 3-digit major number, should it ever be needed */
#define MINOR_LENGTH 4 /* Length of 3-digit minor number */

/* Define other types for use with strcmp() */
#define FINISH "finish"

/* File type definitions */
#define REG "R"
#define SYM "S"
#define HARD "H"
#define DIRECTORY "D"
#define CHARDEV "C"
#define BLOCKDEV "B"
#define FIFO "F"
#define NONEXISTENT "DNE"

typedef struct file_node_structure
{
  char fn[MAX_LENGTH];
  char local[MAX_LENGTH];
  char link[LINK_LENGTH];
  char major[MAJOR_LENGTH];
  char minor[MINOR_LENGTH];
  char sz[SIZE_ORDER];
  char mode[MODE_LENGTH];
  char uid[UID_LENGTH];
  char gid[GID_LENGTH];
  char actime[TIME_LENGTH]; /* same as sending over a "long" type */
  char modtime[TIME_LENGTH]; /* same as sending over a "long" type */
  char linkto[MAX_LENGTH];
  char finish[FINISH_LENGTH];
  off_t real_sz;
  dev_t real_dev;
  mode_t real_mode;
  uid_t real_uid;
  gid_t real_gid;
  struct utimbuf timebuf;
} fnode;

int conv_perms(fnode *node);
void print_fnode(fnode *node);
int nullify_fnode(fnode *node);
int last_node(fnode *node);
int is_symlink(fnode *node);
int is_hardlink(fnode *node);
int is_regular(fnode *node);
int is_dir(fnode *node);
int is_chardev(fnode *node);
int is_blockdev(fnode *node);
int is_fifo(fnode *node);
int is_nonexistent(fnode *node);

#endif /* NODE_H */
