#include "node.h"

int conv_perms(fnode *node)
{
  int DEBUG = 0;
  int oversize = 0;
  errno = 0;
  /*  memmove(&node->mode[0],&node->mode[1],6);*/ /* This works ok with the next line uncommented */
  /*  node->real_mode = strtol(node->mode,(char **)NULL,8);*/
  if (DEBUG) logger(CLI,"conv_perms: Calculating oversize...");
  oversize = (strlen(node->mode) - (MODE_LENGTH-1));
  if (oversize > 0) {
    logger(CLI,"conv_perms: Big mode line = %s with size=%d, chopping by %d characters",node->mode,strlen(node->mode),oversize);
    node->real_mode = strtol(&node->mode[oversize],(char **)NULL,8);
  } else {
    node->real_mode = strtol(node->mode,(char **)NULL,8);
    if (DEBUG) logger(CLI,"conv_perms: No problem with mode = %s, size = %d, actual = %o",node->mode,strlen(node->mode),node->real_mode);
  }
  if (errno == ERANGE)
    logger(CLI,"conv_perms: Problem with converting mode");
  node->real_sz = strtoul(node->sz,(char **)NULL,10);
  if (errno == ERANGE)
    logger(CLI,"conv_perms: Problem with converting size");

  errno = 0;
  node->real_dev = makedev(strtoul(node->major,(char **)NULL,10),strtoul(node->minor,(char **)NULL,10));
  /*  if (errno == ERANGE)*/
  if (errno != 0)
    logger(CLI,"conv_perms: Problem with converting device major/minor numbers");

  node->real_uid = strtol(node->uid,(char **)NULL,10);
  if (errno == ERANGE)
    logger(CLI,"conv_perms: Problem with converting uid");
  node->real_gid = strtol(node->gid,(char **)NULL,10);
  if (errno == ERANGE)
    logger(CLI,"conv_perms: Problem with converting gid");
  node->timebuf.actime = strtol(node->actime,(char **)NULL,10);
  if (errno == ERANGE)
    logger(CLI,"conv_perms: Problem with converting actime");
  node->timebuf.modtime = strtol(node->modtime,(char **)NULL,10);
  if (errno == ERANGE)
    logger(CLI,"conv_perms: Problem with converting modtime");
  if (DEBUG) logger(CLI,"%d = uid, %d = gid %d = actime %d = modtime",node->real_uid,node->real_gid,node->timebuf.actime,node->timebuf.modtime);
  if (errno != 0)
    return(-1);
  else
    return(0);
}

void print_fnode(fnode *node)
{
  int DEBUG = 0;
  
  if (DEBUG) printf("print_fnode: fnode structure\n");
  printf("print_fnode: filename = %s\n",node->fn);
  printf("print_fnode: link = %s\n",node->link);
  printf("print_fnode: major = %s\n",node->major);
  printf("print_fnode: minor = %s\n",node->minor);
  printf("print_fnode: size = %s\n",node->sz);
  printf("print_fnode: mode = %s\n",node->mode);
  printf("print_fnode: uid = %s\n",node->uid);
  printf("print_fnode: gid = %s\n",node->gid);
  printf("print_fnode: actime = %s\n",node->actime);
  printf("print_fnode: modtime = %s\n",node->modtime);
  printf("print_fnode: linkto = %s\n",node->linkto);
  printf("print_fnode: finish = %s\n",node->finish);
  printf("print_fnode: real_sz = %d\n",node->real_sz);
  printf("print_fnode: real_mode = %o\n",node->real_mode);
  printf("print_fnode: real_uid = %d\n",node->real_uid);
  printf("print_fnode: real_gid = %d\n",node->real_gid);
  printf("print_fnode: timebuf.actime = %d\n",node->timebuf.actime);
  printf("print_fnode: timebuf.modtime = %d\n",node->timebuf.modtime);
  if (DEBUG) printf("print_fnode: DONE\n");
}

int nullify_fnode(fnode *node)
{
  int WRONG = 0;
  int DEBUG = 0;
  
  errno = 0;
  if (DEBUG) logger(CLI,"nullify_fnode: Nullifying old fnode");
  if (strcpy(node->fn,"") == NULL) WRONG = -1;
  if (strcpy(node->link,"") == NULL) WRONG = -1;
  if (strcpy(node->major,"") == NULL) WRONG = -1;
  if (strcpy(node->minor,"") == NULL) WRONG = -1;
  if (strcpy(node->sz,"") == NULL) WRONG = -1;
  if (strcpy(node->mode,"") == NULL) WRONG = -1;
  if (strcpy(node->uid,"") == NULL) WRONG = -1;
  if (strcpy(node->gid,"") == NULL) WRONG = -1;
  if (strcpy(node->actime,"") == NULL) WRONG = -1;
  if (strcpy(node->modtime,"") == NULL) WRONG = -1;
  if (strcpy(node->linkto,"") == NULL) WRONG = -1;
  if (strcpy(node->finish,"") == NULL) WRONG = -1;
  if (DEBUG) logger(CLI,"nullify_fnode: Now starting to do the integer values");
  node->real_sz = 0;
  node->real_uid = 0;
  node->real_gid = 0;
  node->real_mode = 0;
  node->real_dev = makedev(0,0);
  node->timebuf.actime = 0;
  node->timebuf.modtime = 0;
  if (DEBUG) logger(CLI,"nullify_fnode: Done nullifying old fnode, ready for new data");
  return(WRONG);
}

int last_node(fnode *node)
{
  if (strcmp(node->finish,FINISH) == 0)
    return(1);
  else 
    return(0);
}

int is_symlink(fnode *node)
{
  if (strcmp(node->link,SYM) == 0)
    return(1);
  else
    return(0);
}

int is_hardlink(fnode *node)
{
  if (strcmp(node->link,HARD) == 0)
    return(1);
  else
    return(0);
}

int is_regular(fnode *node)
{
  if (strcmp(node->link,REG) == 0)
    return(1);
  else
    return(0);
}

int is_dir(fnode *node)
{
  if (strcmp(node->link,DIRECTORY) == 0)
    return(1);
  else
    return(0);
}

int is_chardev(fnode *node)
{
  if (strcmp(node->link,CHARDEV) == 0)
    return(1);
  else
    return(0);
}

int is_blockdev(fnode *node)
{
  if (strcmp(node->link,BLOCKDEV) == 0)
    return(1);
  else
    return(0);
}

int is_fifo(fnode *node)
{
  if (strcmp(node->link,FIFO) == 0)
    return(1);
  else
    return(0);
}

int is_nonexistent(fnode *node)
{
  if (strcmp(node->fn,NONEXISTENT) == 0) {
    if (strcmp(node->link,NONEXISTENT) == 0) {
      return(1);
    }
  }
  else
    return(0);
}

