/* This is part of the rfiledist package. */

/* Written by Tom Kunz <tkunz@fast.net> for the purpose of making a
system to distribute files/packages across a network, ***WAY*** more
powerful than the existing rdist(1) stuff. */

/* Copyright (C) 1999 by Tom Kunz */

/* GPL LICENSE */
/* This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

You can contact me by email at: tkunz@fast.net

You can contact me by snail mail at:
	Tom Kunz
	605 Harmony Brass Castle Rd
	Phillipsburg, NJ  08865

*/


#include "logging.h"
  
void logger(int src, char *msg, ...)
{
  pid_t mypid;
  int logfd;
  char tmpmsg[BIG_BUF];
  char *srcstr;
  char *srcprog;
  char *log_loc;
  int len;
  time_t t;
  struct tm *tm_struct;
  char wholestring[BIG_BUF],timestamp[80];
  va_list ap;
  char dest[BIG_BUF];
  
  va_start(ap,msg);
  vsprintf(dest,msg,ap);
  
  umask(0);
  
  mypid = getpid();
  if (src == 1) {
    srcstr = "SRV";
    srcprog = "refdis.serv";
    log_loc = SERV_LOGFILE_LOC;
  }
  else {
    srcstr = "CLI";
    srcprog = "refdis.cli";
    log_loc = CLI_LOGFILE_LOC;
  }
  t = time(&t);
  tm_struct = localtime(&t);
  strftime(timestamp,40,"%c",tm_struct);
  len = sprintf(wholestring,"%s: %s[%d]: %s\n",timestamp,srcstr,mypid,dest);
  
  if ((logfd = open(log_loc,O_WRONLY | O_APPEND | O_CREAT | O_NONBLOCK,S_IRUSR | S_IWUSR)) < 0) {
#ifdef SOLARIS26_PLATFORM
    openlog(srcprog,LOG_CONS | LOG_NDELAY | LOG_ERR | LOG_PID, LOG_LOCAL3);
#endif
#ifdef LINUX_PLATFORM
    openlog(srcprog,LOG_CONS | LOG_NDELAY | LOG_PERROR | LOG_PID, LOG_LOCAL3);
#endif
    syslog(LOG_WARNING," Unable to open %s: %m",log_loc);
    va_end(ap);
    return;
  }
  if (write(logfd,wholestring,len) < len)
    syslog(LOG_WARNING," Unable to write to %s: %m",log_loc);
  close(logfd);
  va_end(ap);
  return;
}

void logger_syslog(int src, char *msg, ...)
{
  char *srcstr,*srcprog,*log_loc;
  
  if (src == 1) {
    srcstr = "SRV";
    srcprog = "refdis.serv";
    log_loc = SERV_LOGFILE_LOC;
  }
  else {
    srcstr = "CLI";
    srcprog = "refdis.cli";
    log_loc = CLI_LOGFILE_LOC;
  }
  logger(src, msg);
#ifdef SOLARIS26_PLATFORM
  openlog(srcprog,LOG_CONS | LOG_NDELAY | LOG_ERR | LOG_PID, LOG_LOCAL3);
#endif
#ifdef LINUX_PLATFORM
  openlog(srcprog,LOG_CONS | LOG_NDELAY | LOG_PERROR | LOG_PID, LOG_LOCAL3);
#endif
  syslog(LOG_WARNING,msg,log_loc);
  return;
}
