/* This is part of the rfiledist package. */

/* Written by Tom Kunz <tkunz@fast.net> for the purpose of making a
system to distribute files/packages across a network, ***WAY*** more
powerful than the existing rdist(1) stuff. */

/* Copyright (C) 1999 by Tom Kunz */

/* GPL LICENSE */
/* This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

You can contact me by email at: tkunz@fast.net

You can contact me by snail mail at:
	Tom Kunz
	605 Harmony Brass Castle Rd
	Phillipsburg, NJ  08865

*/


#ifndef LISTLIB_H
#define LISTLIB_H

typedef struct _listnode
{
  void *data;
  struct _listnode *next;
} *listnode;

typedef struct _list
{
  listnode head, tail, current;
  int length;
  void *label;
} *list;

#ifndef BOOL
typedef enum {false=0, true} boolean;
#define BOOL
#endif

list lstcreate(void *name);  /*initialize a list with label name before use */

void lstrename(list L, void *newname); /* replaces label with the newname */

void lstdestroy(list L);   /* must be called to discard list after use */

void append(list L, void *data); /* appends data pointer to end of the list */
     /* does NOT reset the current pointer */

void clear(list L);        /* deletes all list entries */

void *first(list L); 
     /* returns value of the data ptr in first entry of list */
     /* sets current to first entry */

void *next(list L);
     /* returns the value of the data pointer in the next entry of the list*/ 
     /* sets current to next entry */
     /* if there are no more entries in the list, the function returns NULL */

void delete(list L); /* deletes the current entry in the list */
     /* resets the current entry to the preceding entry */

void insert(list L, void *data); /* inserts data into new node before current*/
     /* makes the newnode the current node */

boolean is_empty(list L); /* returns true if list if empty, false otherwise */

void display(list L);  /* outputs the label of the list and all list entries*/
     /* calls functions printListLabel(label) and printListData(data) */
     /* These two functions will be included with the application code */
     /* and will typecast the void * ptr according to the the application. */

#endif /* LISTLIB_H */
