/* This is part of the rfiledist package. */

/* Written by Tom Kunz <tkunz@fast.net> for the purpose of making a
system to distribute files/packages across a network, ***WAY*** more
powerful than the existing rdist(1) stuff. */

/* Copyright (C) 1999 by Tom Kunz */

/* GPL LICENSE */
/* This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

You can contact me by email at: tkunz@fast.net

You can contact me by snail mail at:
	Tom Kunz
	605 Harmony Brass Castle Rd
	Phillipsburg, NJ  08865

*/


#include <stdio.h>
#include <stdlib.h>
#include "listlib.h"

list lstcreate(void *name)
{
   list L;

   L = malloc(sizeof(struct _list));
   if (L == NULL) {
      fprintf(stderr, "create: no more space, exiting");
      exit(1);
    }

   L->head = NULL;
   L->tail = NULL;
   L->current = NULL;
   L->length = 0;
   L->label = name;
   return L;
 }

void lstrename(list L, void *newname)
{
	L->label = newname;
}

void lstdestroy(list L)
{
   free(L);
 }

void append(list L, void *data)
{
   listnode p;

   p = malloc(sizeof(struct _listnode));
   if (p == NULL) {
      fprintf(stderr, "insert: no more space, exiting\n");
      exit(1);
    }

   p->data = data;
   p->next = NULL;

   if (L->tail == NULL) { L->head = p; L->current = p;}
   else { L->tail->next = p; }

   L->tail = p;
   L->length++;
 }


void clear(list L)
{
   listnode ptr, succ;

   if (L->tail == NULL) return;

   if (L->tail == L->head) {
      free(L->tail);
      L->head = L->tail = NULL;
      return;
    }

   ptr = L->head;
   succ = L->head->next;

   do {
     free(ptr);
     ptr = succ;
     if (succ != NULL) succ = succ->next;
   } while (ptr != NULL);

   L->head = L->tail = L->current = NULL;
   L->length = 0;
}

void *first(list L)
{
   if (L->tail == NULL) return(NULL);
   L->current = L->head;
   return(L->current->data);

}

void *next(list L)
{
   if (((L->current == NULL) && (L->head == NULL)) || (L->current == L->tail))
        return(NULL);
   if (L->current == NULL) L->current = L->head;
   else L->current = L->current->next;
   return(L->current->data);
}

void delete(list L)
{
   listnode ptr;

   if (L->current == NULL) {
      fprintf(stderr, "delete: no current entry, exiting\n");
      exit(1);
   }
   if (L->current == L->head) {
	L->head = L->current->next;
        if (L->head == NULL) L->tail = NULL;
	free(L->current);
        L->current =  NULL;
   } else {
	ptr = L->head;
	while (ptr->next != L->current) ptr = ptr->next;
	ptr->next = L->current->next;
	free(L->current);
	L->current = ptr;
   }
   L->length--;
}

void insert(list L, void *data)
{
   listnode p,ptr;

   p = malloc(sizeof(struct _listnode));
   if (p == NULL) {
      fprintf(stderr, "insert: no more space, exiting\n");
      exit(1);
    }

   p->data = data;
   p->next = L->current;

   if (L->current == L->head) {
	L->head = p;
   } else {
	ptr = L->head;
	while (ptr->next != L->current) ptr = ptr->next;
	ptr->next = p;
   }
   L->current = p;
   L->length++;
}

boolean is_empty(list L)
{
   return(!L->length);
 }

void display(list L)
{
   listnode pt = L->tail;

   printListLabel(L->label);
   if (pt == NULL)
      printf(": (  )\n");
   else {
      pt = L->head;
      printf(": ( ");
      do {
         printListData(pt->data);
         printf(" ");
         pt = pt->next;
       } while (pt != NULL);
      printf(")\n");
    }
}

void *getname(list L)
{
  return(L->label);
}
