#ifndef IO_H
#define IO_H
#ifndef HEADER_H
#include "header.h"
#endif
#define MAX_LENGTH 4096
#define NEWLINE "\n"
#define NEWLINE_SIZE sizeof(NEWLINE)


/* Just for reference:
   0 = STDIN
   1 = STDOUT
   2 = STDERR
   All other descriptors are fair game 
   */

/* readstring reads data up to a '\n'.  Puts everything *BEFORE* '\n'
   into the location pointed at by "void *text".  It returns the
   number of bytes read. */
ssize_t readstring(int fd, void *text, size_t maxlen);

/* readline reads data up to and including '\n'.  The whole line,
   '\n' and all, goes into "void *text".  It returns the number of
   bytes read. */
ssize_t readline(int fd, void *text, size_t maxlen);

/* writestring writes all the data in "void *text" out to the specified
   descriptor.  It returns the number of bytes written out.*/
ssize_t writestring(int fd, void *text);

/* writeline writes all the data in "void *text" out to the specified
   descriptor, plus a newline.  It returns the number of bytes written
   out.*/
ssize_t writeline(int fd, void *text);

/* sendfile writes the specified filename to the specified socket
   descriptor.  Returns -1 on error or 0 if ok. */
int sendfile(char *name, int sock);

/* recvfile creates a new file by the specified name and reads from
   sock until EOF */
int recvfile(char *name, int sock);

#endif
