#include "io.h"

ssize_t readstring(int fd, void *vptr, size_t maxlen)
{
  ssize_t n, rc;
  char    c, *ptr, nothing;

  ptr = vptr;
  for (n = 1; n < maxlen; n++) {
    if ( (rc = read(fd, &c, 1)) == 1) {
      while ((c == '\0')||(c == '\r')) 
	read(fd,&c,1);
      if (c == '\n') {
	*ptr++ = '\0';
	*ptr = 0;
	return(n);
      }
      *ptr++ = c;
    } else if (rc == 0) {
      if (n == 1)
	return(0);      /* EOF, no data read */
      else
	break;          /* EOF, some data was read */
    } else
      return(-1);     /* error */
  }
  *ptr++ = '\0';
  *ptr = 0;
  return(n);
}

ssize_t readline(int fd, void *vptr, size_t maxlen)
{
  ssize_t n, rc;
  char    c, *ptr;
  ptr = vptr;
  for (n = 1; n < maxlen; n++) {
    if ( (rc = read(fd, &c, 1)) == 1) {
      while ((c == '\0')||(c == '\r'))
	read(fd,&c,1);
      *ptr++ = c;
      if (c == '\n')
	break;
    } else if (rc == 0) {
      if (n == 1)
	return(0);      /* EOF, no data read */
      else
	break;          /* EOF, some data was read */
    } else
      return(-1);     /* error */
  }
  *ptr++ = '\0';
  *ptr = 0;
  return(n);
}


ssize_t writestring(int fd, void *text)
{
  char *ptr;
  ssize_t i=1,tst=1;
  ssize_t data;
  (char *)ptr = (char *)text;
  while (i){
    if (*ptr++ != '\0'){
      tst++;
    }
    else
      i = 0;
  }
  data = write(fd,text,tst-1);
  if (data < 0)
      return(-1);
  return(tst);
}

ssize_t writeline(int fd, void *text)
{
  char *ptr;
  ssize_t i=1,tst=1;
  ssize_t data,newline;
  (char *)ptr = (char *)text;
  while (i){
    if (*ptr++ != '\0'){
      tst++;
    }
    else
      i = 0;
  }
  if ((data = write(fd,text,tst-1)) < 0) {
    printf("writeline: data write - error %d after writing %d\n",errno,data);
    return(-1);
  }
  if ((newline = write(fd,NEWLINE,NEWLINE_SIZE-1)) < 0) {
    printf("writeline: newline write - error %d after writing %d\n",errno,data);
    return(-1);
  }
  
  tst += (NEWLINE_SIZE-1);
  return(tst);
}

int sendfile(char *name, int sock)
{
  int sourcefd, i = 0, j = 0, k = 0, OK = 1, nleft = MAX_LENGTH;
  /*  char *buf = malloc(MAX_LENGTH);*/
  char buf[MAX_LENGTH];
  
  if ((sourcefd = open(name,O_RDONLY)) < 0)
    return(-1);
  /*  printf("Opened %s ok\n",name);*/
  
  while (OK) {
    if ((i = read(sourcefd,buf,MAX_LENGTH)) > 0) {
      if ((j = write(sock,buf,i)) != i){
	
	while ((nleft = (i - j)) > 0) {
	  k = write(sock,&buf[j],MAX_LENGTH - j);
	  nleft = i - (j + k);
	  j += k;
	}
      }
    
    }
    else if (i == 0) {
      OK = 0;
      return(0);
    }
    else
      return(-1);
  }
}

int recvfile(char *name,int sock)
{
  int DEBUG = 0;
  int destfd, i = 0, j = 0, k = 0, OK = 1, nleft = MAX_LENGTH;
  char buf[MAX_LENGTH];
  
  if ((destfd = open(name,O_WRONLY|O_CREAT,0666)) < 0) {
    if (DEBUG) printf("Bad open, destfd = %d, filename = %s\n",destfd,name);
    return(-1);
  }
  if (DEBUG) printf("Made the open ok %d\n",destfd);
  
  while (OK) {
    if ((i = read(sock,buf,MAX_LENGTH)) > 0) {
      if ((j = write(destfd,buf,i)) != i)
	while ((nleft = (i - j)) > 0) {
	  k = write(destfd,&buf[j],MAX_LENGTH - j);
	  nleft = i - (j + k);
	  j += k;
	}
    }
    else if (i == 0) {
      OK = 0;
      close(destfd);
      return(0);
    }
    else {
      close(destfd);
      return(-1);
    }
  }
}
