/* This is part of the rfiledist package. */

/* Written by Tom Kunz <tkunz@fast.net> for the purpose of making a
system to distribute files/packages across a network, ***WAY*** more
powerful than the existing rdist(1) stuff. */

/* Copyright (C) 1999 by Tom Kunz */

/* GPL LICENSE */
/* This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

You can contact me by email at: tkunz@fast.net

You can contact me by snail mail at:
	Tom Kunz
	605 Harmony Brass Castle Rd
	Phillipsburg, NJ  08865

*/


#include "header.h"

/* Intended to generate entries in a package file.  Not very
   sophisticated.  This way of doing things might be determined to be
   bad, and it might be replaced by simply taking the perms off the
   existing file, rather than trying to make up this file of possibly
   different perms.  However, I liked the idea of a permissions file.
   Two different clients could ask for different package names, but
   recieve the same *binary* package, but with a different set of
   permissions on them, thus making it so that you don't need to
   maintain a split "tree" of a package, and making customizing
   scripts. */

void main(int argc,char *argv[]) 
{
  int i;
  struct stat statbuf;
#ifdef PATH_MAX
  char linkpath[PATH_MAX];
#else
  char linkpath[1024];
#endif
  int linklength;

  for (i = 1; i < argc; i++) {
    lstat(argv[i],&statbuf);
    printf("%s\n",argv[i]);
    printf("/%s\n",argv[i]);
    if ((S_ISREG(statbuf.st_mode)) && (statbuf.st_nlink == 1)){
      printf("R\n");
      printf("%d\n",statbuf.st_size);
      printf("%o\n",(statbuf.st_mode));/* & 0037777));*/
    }
    else if (S_ISLNK(statbuf.st_mode))
      printf("S\n");
    else if (statbuf.st_nlink != 1)
      printf("H - CHECK LINKAGE\n");
    printf("%d\n",statbuf.st_uid);
    printf("%d\n",statbuf.st_gid);
    printf("%d\n",statbuf.st_atime);
    printf("%d\n",statbuf.st_mtime);
    if ((S_ISLNK(statbuf.st_mode)) || (statbuf.st_nlink != 1)) {
      if ((linklength=readlink(argv[i],linkpath,sizeof(linkpath))) < 0) {
	printf("Check Link");
      } else {
	for(i=0;i < linklength;i++) {
	  printf("%c",linkpath[i]);
	}
      }
      printf("\n");
    }
    
    
    if ((i+1.5) <= argc) {
      printf("---\n");
    }
  }
  printf("finish\n");
}

    
