#include "comm.h"
#include "header.h"

int make_sock(conn *C,int port)
{
  int set = 1; /* For turning on SO_REUSEADDR */
  int err = 1;
  if (memset((char *)&(C->sockaddr),0,sizeof(C->sockaddr)) == NULL) {
    logger(CLI,"make_sock: memset() failed!");
  }
  C->sockaddr.sin_family = AF_INET;
  C->sockaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  C->sockaddr.sin_port = htons(port);
  if ((C->lst_sock = socket(AF_INET,SOCK_STREAM,0)) < 0) {
    logger(CLI,"make_sock: can't open stream socket");
  }
  if (setsockopt(C->lst_sock,SOL_SOCKET,SO_REUSEADDR,(char*)&set,sizeof(set)) < 0){
    logger(CLI,"make_sock: Bad setsockopt");
  }

  while (bind(C->lst_sock,(struct sockaddr *)&(C->sockaddr),sizeof(C->sockaddr)) < 0) {
    logger(CLI,"make_sock: can't bind local address to %d, kill and restart\n",C->lst_sock);
    printf("make_sock: can't bind local address to %d, kill and restart\n",C->lst_sock);
    sleep(1);
  }
  if (listen(C->lst_sock,128) != 0) {
    logger(CLI,"make_sock: listen fault");
  }
  return(C->lst_sock);
}

int send_recv(int sock,char *data)
{
  int DEBUG = 0;
  char *recvACK = malloc(ONE_CHAR);
  int WRONG = 0;
  struct sigaction intr,ointr;
  
  intr.sa_flags = 0;
  sigemptyset(&intr.sa_mask);
  intr.sa_handler = NULL;
  
  if (sigaction(SIGALRM,&intr,&ointr) < 0){
    logger(CLI,"send_recv: error setting sigaction(SIGALRM)");
  }
  alarm(UTO);
  if (DEBUG) logger(CLI,"send_recv: sending %s to %d\n",data,sock);
  if (writeline(sock,data) < 0)
    WRONG = -1;/*std_quit("send_recv: problem doing writeline()");*/
  if (DEBUG) logger(CLI,"send_recv: sent %s to %d\n",data,sock);
  if (Readstring(sock,recvACK,MAX_LENGTH) < 0)
    WRONG = -1;/*std_quit("send_recv: problem getting ACK");*/
  alarm(0);
  if (sigaction(SIGALRM,&ointr,&intr) < 0){
    logger(CLI,"send_recv: error resetting sigaction(SIGALRM)");
  }
  return(WRONG);
}

int recv_send(int sock,char *data)
{
  int DEBUG = 0;
  int WRONG = 0;
  int SENT = 0;
  struct sigaction intr,ointr;
  
  intr.sa_flags = 0;
  sigemptyset(&intr.sa_mask);
  intr.sa_handler = NULL;
  
  if (sigaction(SIGALRM,&intr,&ointr) < 0){
    logger(CLI,"send_recv: error setting sigaction(SIGALRM)");
  }
  alarm(UTO);
  if ((WRONG = Readstring(sock,data,MAX_LENGTH)) < 0)
    logger(CLI,"recv_send: Bad recv.  Attempting to send.\n");
  if ((SENT = sendACK(sock,ACK_CHAR)) < 0) {
    logger(CLI,"recv_send: error sending ACK");
    alarm(0);
    return(SENT);
  }
  alarm(0);
  if (sigaction(SIGALRM,&ointr,&intr) < 0){
    logger(CLI,"send_recv: error resetting sigaction(SIGALRM)");
  }
  return(WRONG);
}

int tcp_open(char *host, char *service, int port)
{
  struct sockaddr_in tcp_srv_addr;
  struct servent tcp_serv_info;
  struct hostent tcp_host_info;
  int fd,resvport;
  unsigned long inaddr;
  struct servent *sp;
  struct hostent *hp;
  
  if (memset((char*)&tcp_srv_addr,0,sizeof(tcp_srv_addr)) == 0){
    logger(CLI,"tcp_open: big problems (you might want this proc to die).");
    return(-1);
  }
  tcp_srv_addr.sin_family = AF_INET;
  if (service != NULL) {
    if ((sp = getservbyname(service,"tcp")) == NULL){
      logger(CLI,"tcp_open: unknown service: %s/tcp",service);
      return(-1);
    }
    tcp_serv_info = *sp;
    if (port > 0)
      tcp_srv_addr.sin_port = htons(port);
    else
      tcp_srv_addr.sin_port = sp->s_port;
  }
  else {
    if (port <= 0) {
      logger(CLI,"tcp_open: must specify either service or port");
      return(-1);
    }
    tcp_srv_addr.sin_port = htons(port);
  }

  /* First attempt to convert address to dotted decimal format.  If that
     fails, try to use gethostbyname().  */
  
  if ((inaddr = inet_addr(host)) != INADDR_NONE) {
    bcopy((char *)&inaddr,(char *)&tcp_srv_addr.sin_addr,sizeof(inaddr));
    tcp_host_info.h_name = NULL;
  }
  else {
    if((hp = gethostbyname(host)) == NULL) {
      return(-1);
    }
    tcp_host_info = *hp;
    bcopy(hp->h_addr,(char *)&tcp_srv_addr.sin_addr,hp->h_length);
  }
  if (port >= 0) {
    if ((fd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
      logger(CLI,"tcp_open: can't create TCP socket");
      return(-1);
    }
  }
  else if (port < 0) {
    resvport = IPPORT_RESERVED - 1;
    if ((fd = rresvport(&resvport)) < 0){
      logger(CLI,"tcp_open: can't get a reserved TCP port");
      return(-1);
    }
  }
  /* Connect to the server. */
  if (connect(fd,(struct sockaddr *)&tcp_srv_addr,sizeof(tcp_srv_addr)) < 0){
    logger(CLI,"tcp_open: can't connect to the server");
    close(fd);
    return(-1);
  }
  /* All sockets and everything are ok. */
  return(fd);
}

#define MAXLINE2 4096
static ssize_t
my_read(int fd, char *ptr)
{
  static int      read_cnt = 0;
  static char     *read_ptr;
  static char     read_buf[MAXLINE2];
  
  if (read_cnt <= 0) {
  again:
    if ( (read_cnt = read(fd, read_buf, sizeof(read_buf))) < 0) {
      if (errno == EINTR)
	goto again;
      return(-1);
    } else if (read_cnt == 0)
      return(0);
    read_ptr = read_buf;
  }
  
  read_cnt--;
  *ptr = *read_ptr++;
  return(1);
}

ssize_t
readline2(int fd, void *vptr, size_t maxlen)
{
  int             n, rc;
  char    c, *ptr;
  
  ptr = vptr;
  for (n = 1; n < maxlen; n++) {
    if ( (rc = my_read(fd, &c)) == 1) {
      *ptr++ = c;
      if (c == '\n')
	break;  /* newline is stored, like fgets() */
    } else if (rc == 0) {
      if (n == 1)
	return(0);      /* EOF, no data read */
      else
	break;          /* EOF, some data was read */
    } else
      return(-1);             /* error, errno set by read() */
  }
  
  *ptr = 0;       /* null terminate like fgets() */
  return(n);
}
/* end readline */

ssize_t
Readline(int fd, void *ptr, size_t maxlen)
{
  ssize_t         n;
  
  if ( (n = readline2(fd, ptr, maxlen)) < 0)
    /*                err_sys("readline error");*/
    logger(CLI,"Readline Error (NEW READLINE FCN)\n");
  
  return(n);
}
ssize_t
Readstring(int fd, void *ptr, size_t maxlen)
{
  ssize_t         n;
  
  if ( (n = readstring2(fd, ptr, maxlen)) < 0)
    /*                err_sys("readline error");*/
    logger(CLI,"Readstring: Error (NEW READSTRING FCN)\n");
  
  return(n);
}

ssize_t
readstring2(int fd, void *vptr, size_t maxlen)
{
  int             n, rc;
  char    c, *ptr;
  
  ptr = vptr;
  for (n = 1; n < maxlen; n++) {
    if ( (rc = my_read(fd, &c)) == 1) {
      if (c == '\n')
	break;  /* newline is NOT stored! */
      *ptr++ = c;
    } else if (rc == 0) {
      if (n == 1)
	return(0);      /* EOF, no data read */
      else
	break;          /* EOF, some data was read */
    } else
      return(-1);             /* error, errno set by read() */
  }
  
  *ptr = 0;       /* null terminate like fgets() */
  return(n);
}
/* end readstring2 */


