/************************************************************************
 * pulse 1.0 - Copyright (c) 1998-1999 Shahbaz Javeed.                  *
 *                                                                      *
 * This program and its source code is made available free of charge    *
 * under the GPL license.  In brief, you may use it in any way but I    *
 * will not be responsible for any damage that this program causes to   *
 * you or your computer.  Additionally, if you modify this program or   *
 * make a program based on this one (or its source) please make sure to *
 * mention that your work is based on mine. :)                          *
 ************************************************************************/

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <unistd.h>

/*
#define DEBUG
 */

#define SUCCESS 0
#define  NOARGS 1

#define  TRUE 1
#define FALSE 0

#define  SECPERDAY 86400   /* Number of seconds in a day */
#define SECPERHOUR  3600   /* Number of seconds in an hour */
#define  SECPERMIN    60   /* Number of seconds in a minute */

#define   MAXSLEEP UINT_MAX   /* Maximum number of seconds we can sleep at a time */

/*
 * Structure to hold time interval between pulses...
 */
typedef struct {
   unsigned int days;
   unsigned int hours;
   unsigned int minutes;
   unsigned int seconds;
   unsigned int numberDots;
   unsigned char helpWanted;
} timeStruct;


int ParseArguments (int argCount, char *argValue [], timeStruct *reqdTime);

#ifdef DEBUG
void PrintSleeptime (timeStruct *reqdTime);
#endif

void SleepFor (timeStruct *reqdTime);



void main (int argc, char *argv []) {
   int loop = 0;
   int dot = 0;
   int outputFlag;
   timeStruct sleepTime = {0, 0, 0, 0, 0, FALSE};
   
   if (argc < 2)
     sleepTime.seconds = 1;
   
   outputFlag = ParseArguments (argc, argv, &sleepTime);

#ifdef DEBUG
   PrintSleeptime (&sleepTime);
#endif DEBUG
   
   if (TRUE == sleepTime.helpWanted) {
      printf ("pulse v1.0 - Generate pulses (dots) with user defined period\n\n");
      printf ("Syntax: \n");
      printf ("Help: pulse -?\n\n");
      printf ("pulse -d <D> -h <H> -m <M> -s <S>\n");
      printf ("-d <D>: Wait for D days between dots\n");
      printf ("-h <H>: Wait for H hours between dots\n");
      printf ("-m <M>: Wait for M minutes between dots\n");
      printf ("-s <S>: Wait for S seconds between dots\n");
      printf ("-n <N>: Maximum number of dots to output\n");
      printf ("-S    : Silent... Suppress output of dots\n\n");
      printf ("Multiple switches results in addition of all specified times\n");
      printf ("No arguments results in a pulse period of 1 second, i.e. pulse -s 1\n\n");
      printf ("Example: pulse -h 1 -m 30 -n 15\n");
      printf ("Interpretation: Output a total of 15 dots with a time delay of 1 hour \n");
      printf ("                and 30 minutes between each dot\n\n");
      exit (SUCCESS);
   }
      
   if (0 < sleepTime.numberDots) {
      for (dot = 0; dot < sleepTime.numberDots; dot ++) {
	 SleepFor (&sleepTime);
	 if (outputFlag) putchar ('.');
      }
      exit (SUCCESS);
   }
   
   while (1) {
      SleepFor (&sleepTime);
      if (outputFlag) putchar ('.');
   }
}




int ParseArguments (int argCount, char *argValue [], timeStruct *reqdTime) {
   char optionChar;
   char timeSet = FALSE;
   int outputFlag = 1;
   
   optionChar = getopt (argCount, argValue, "d:h:m:s:n:?S");
   while (EOF != optionChar) {
      switch (optionChar) {
       case 'd':
	 reqdTime -> days = abs (atoi (optarg));
	 timeSet = TRUE;
	 break;
	 
       case 'h':
	 reqdTime -> hours = abs (atoi (optarg));
	 timeSet = TRUE;
	 break;
	 
       case 'm':
	 reqdTime -> minutes = abs (atoi (optarg));
	 timeSet = TRUE;
	 break;
	 
       case 's':
	 reqdTime -> seconds = abs (atoi (optarg));
	 timeSet = TRUE;
	 break;

       case 'n':
	 reqdTime -> numberDots = abs (atoi (optarg));
	 break;
	 
       case '?':
	 reqdTime -> helpWanted = TRUE;
	 break;
	 
       case 'S':
	 outputFlag = 0;
	 break;
      }
      optionChar = getopt (argCount, argValue, "d:h:m:s:n:?S");
   }
   
   if (FALSE == timeSet)
     reqdTime -> seconds = 1;
   
   return outputFlag;
}


#ifdef DEBUG
void PrintSleeptime (timeStruct *reqdTime) {
   printf ("Pulsing after every: \n");
   
   if (0 < reqdTime -> days)
     printf ("  %u days", reqdTime -> days);
   
   if (0 < reqdTime -> hours)
     printf (" %u hours", reqdTime -> hours);
   
   if (0 < reqdTime -> minutes)
     printf (" %u minutes", reqdTime -> minutes);
   
   if (0 < reqdTime -> seconds)
     printf (" %u seconds", reqdTime -> seconds);
   
   if (0 < reqdTime -> numberDots)
     printf (" %u dots (MAX)", reqdTime -> numberDots);
   
   printf ("\n");
}
#endif


void SleepFor (timeStruct *reqdTime) {
   long totalTime =
     ((long) reqdTime -> days * SECPERDAY) +
     ((long) reqdTime -> hours * SECPERHOUR) +
     ((long) reqdTime -> minutes * SECPERMIN) +
     ((long) reqdTime -> seconds);
   long numberLoops = totalTime / MAXSLEEP;
   long remainder = totalTime % MAXSLEEP;
   long loop;

   fflush (stdout);
   
   for (loop = 0; loop < numberLoops; loop ++)
     sleep (MAXSLEEP);
   
   sleep (remainder);
}
