/***************************************************************************
 *
 * Copyright (c) 1998 Balazs Scheidler
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#include "utils.h"

#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ctype.h>


#include "nsyslogd.h"
#include "var.h"

char	myhostname[MAXHOSTNAMELEN+1];
char	fullhostname[MAXHOSTNAMELEN+1];

char *
get_shorthostname()
{
	char *s;

	if (!*myhostname) {
		gethostname(myhostname, MAXHOSTNAMELEN);
		myhostname[MAXHOSTNAMELEN] = '\0';
		s = strchr(myhostname, '.');
		if (s != NULL)
			*s = '\0';
	}

	if (!*fullhostname) {
		gethostname(fullhostname, MAXHOSTNAMELEN);
		fullhostname[MAXHOSTNAMELEN] = '\0';
	}
	return myhostname;
}

char *
get_fullhostname()
{
	char *s;

	if (!*myhostname) {
		gethostname(myhostname, MAXHOSTNAMELEN);
		myhostname[MAXHOSTNAMELEN] = '\0';
		s = strchr(myhostname, '.');
		if (s != NULL)
			*s = '\0';
	}

	if (!*fullhostname) {
		gethostname(fullhostname, MAXHOSTNAMELEN);
		fullhostname[MAXHOSTNAMELEN] = '\0';
	}
	return fullhostname;
}

struct in_addr
getipv4addr(arg)
	char *arg;
{
	struct hostent *hp;
	struct in_addr in;

	in.s_addr = 0xffffffff;

	if ((hp = gethostbyname(arg)))
		memcpy(&in.s_addr, hp->h_addr, sizeof(struct in_addr));
	else
		in.s_addr = inet_addr(arg);
	return in;
}


u_short
getportnum(pr, name)
	char *pr, *name;
{
	struct servent *sp;

	if (!(sp = getservbyname(name, pr)))
		return htons(atoi(name));
	return sp->s_port;
}


struct in_addr
getipmask(arg)
	char *arg;
{
	struct in_addr in;
	int val;

	if (!strchr(arg, '.')) {
		val = atoi(arg);

		if (isdigit(*arg) && val >=0 && val <= 32) {
			in.s_addr = 0;
			for (; val; val--) {
				in.s_addr >>= 1;
				in.s_addr |= 0x8000000;
			}
			in.s_addr = htonl(in.s_addr);
		} else
			in.s_addr = htonl((u_long)strtol(arg, NULL, 0));
	} else
		in.s_addr = inet_addr(arg);
	return in;
}

char *
chomp(str)
	char *str;
{
	int n;
	n = strlen(str);
	while (n > 0 && (str[n - 1] == '\n' || str[n - 1] == '\r')) {
		str[n - 1] = 0;
		n--;
	}
	return str;
}
