/***************************************************************************
 *
 * Copyright (c) 1998 Balazs Scheidler
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __SHA1_H
#define __SHA1_H

#include "config.h"

#include "hash.h"

#define	SHA1_STATE_SZ	5
#define	SHA1_CNT_SZ	2
#define	SHA1_BUF_SZ	64
#define	SHA1_DIGEST_SZ	20


typedef struct {
    unsigned long state[SHA1_STATE_SZ];
    unsigned long count[SHA1_CNT_SZ];
    unsigned char buffer[SHA1_BUF_SZ];
} SHA1_CTX;


extern	hash_context_t	SHA1Create __P((void));
extern	void	SHA1Destroy __P((hash_context_t));
extern	void	SHA1Init __P((hash_context_t));
extern	void	SHA1Update __P((hash_context_t, char *, int));
extern	void	SHA1Final __P((hash_context_t, char **, int *));

#endif
