/***************************************************************************
 *
 * Copyright (c) 1998 Balazs Scheidler
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#include "oldcf.h"

#include <stdio.h>
#include <errno.h>
#include <syslog.h>
#include <ctype.h>
#include <string.h>
#include <netdb.h>

#include "nsyslogd.h"
#include "log.h"
#include "y.tab.h"
#include "var.h"

#if !defined(lint)
static const char rcsid[] = "$Id: oldcf.c,v 1.14 1998/12/01 18:10:00 bazsi Exp $";
#endif

static	void	cfline		__P((char *, var_t *));
static 	int	check_comp	__P((char **));

#ifdef USE_M4_PREPROCESS
static	int	am_i_loghost	__P((void));
#endif

static int
check_comp(str)
	char **str;
{
	char *s = *str;

	if (!strncmp(s, "=", 1)) {
		*str = s + 1;
		return IL_EQ;
	}
	if (!strncmp(s, "!=", 2)) {
		*str = s + 2;
		return IL_NEQ;
	}
	if (!strncmp(s, "<=", 2)) {
		*str = s + 2;
		return IL_LE;
	}
	if (!strncmp(s, ">=", 2)) {
		*str = s + 2;
		return IL_GE;
	}
	if (!strncmp(s, "<", 1)) {
		*str = s + 1;
		return IL_LT;
	}
	if (!strncmp(s, ">", 2)) {
		*str = s + 1;
		return IL_GT;
	}
	return IL_GE;
}


/*
 * Read in a line from the old configuration file format and translate it
 * into the new format.
 */
static void
cfline(line, match)
	char *line;
	var_t *match;
{
	fillist_t *fl = NULL, *fn = NULL;
	char buf[MAXLINE];
	char *bp, *p, *q, *t;
	var_t *s, *v = NULL, *f = NULL;
	int i = 0, pri, comp;

	if (opts & OPT_VERBOSE)
		fprintf(stderr, "cfline(%s)\n", line);

	/* scan through the list of selectors */
	for (p = line; *p && *p != '\t';) {

		/* find the end of this facility name list */
		for (q = p; *q && *q != '\t' && *q++ != '.'; )
			continue;

		/* collect priority name */
		for (bp = buf; *q && !strchr("\t,;", *q); )
			*bp++ = *q++;
		*bp = '\0';

		/* skip cruft */
		while (strchr(", ;", *q))
			q++;

		t = buf;
		comp = IL_GE;
		/* decode priority name */
		if (*t == '*')
			pri = LOG_PRIMASK + 1;
		else {
			comp = check_comp(&t);
			pri = find_priname(t);
			if (pri < 0) {
				log_printf(LOG_SYSLOG | LOG_ERR, "unknown priority name \"%s\"", t);
				return;
			}
		}

		/* scan facilities */
		i = -1;
		while (*p && !strchr("\t.;", *p)) {
			for (bp = t; *p && !strchr("\t,;.", *p); )
				*bp++ = *p++;
			*bp = '\0';
			if (*t != '*') {
				i = find_facname(t);
				if (i < 0) {
					log_printf(LOG_SYSLOG | LOG_ERR, "unknown facility name \"%s\"", t);
					return;
				}
			}
			while (*p == ',' || *p == ' ')
				p++;
		}

		p = q;

		if ((i >= 0) || pri != (LOG_PRIMASK + 1)) {
			if (!(i >= 0))
				f = add_obj(FIL_PRI, new_prival(pri, comp));
			else if (pri == LOG_PRIMASK + 1)
				f = add_obj(FIL_FAC, new_facval(i));
			else
				f = add_obj(FIL_FACPRI,
					    new_facprival(i|pri, comp));
			end_obj();

			if (!fn && !(NEW(fn)))
				exit(1);
			if (fn->fl_fil) {
				if (!(NEW(fl)))
					exit(1);
				fl->fl_or = fn->fl_or;
				fn->fl_or = fl;
			} else
				fl = fn;
			f->v_cnt++;
			fl->fl_fil = f;
			fl = NULL;
			f = NULL;
		}

	}

	if (match) {
		if (fl) {
			if (!(NEW(fl->fl_and)))
				exit(1);
			fl->fl_and->fl_fil = match;
		} else {
			if (!(NEW(fl)))
				exit(1);
			fl->fl_fil = match;
			match->v_cnt++;
		}
		if (fn) {
			fl->fl_or = fn->fl_or;
			fn->fl_or = fl;
		} else
			fn = fl;
	}

	/* skip to action part */
	while (*p == '\t')
		p++;

	/*
	 * Create a new destination object and give it the correct type
	 * for the member.
	 */
	switch (*p)
	{
	case '@':
		set_raw();
		v = add_obj(DEST_INET, new_net(DEST_INET, NET_UDP,
					       p + 1, "514"));
		break;

	case '/':
		v = add_obj(DEST_FILE, new_file(DEST_FILE, p));
		break;

	case '|':
		v = add_obj(DEST_CMD, new_cmd(p + 1));
		break;

	case '*':
	default:
		while (*p) {
			char ch;

			for (q = p; *q && *q != ','; )
				q++;
			ch = *q;
			*q = '\0';

			v = add_obj(DEST_USER, new_user(p));

			*q = ch;
			while (*q == ',' || *q == ' ')
				q++;
			p = q;
		}
		break;
	}
	end_obj();

	s = get_var("syslog");

	link_sfd(s, fn, v);
}


#ifdef	USE_M4_PREPROCESS
static int
am_i_loghost()
{
	struct hostent *hp;
	struct in_addr *ips;
	int i, cnt;

	hp = gethostbyname("loghost");
	if (!hp)	/* if no loghost, then I am loghost */
		return 1;

	for (i = 0; hp->h_addr_list[i]; i++)
		;

	ips = (struct in_addr *)malloc(sizeof(*ips) * (i + 1));
	for (i = 0; hp->h_addr_list[i]; i++)
		memcpy((char *)&ips[i], hp->h_addr_list[i], sizeof(ips[i]));

	cnt = i;
	for (i = 0; i < cnt; i++) {
		if (((ntohl(ips[i].s_addr) & 0xff000000) >> 24) ==
		    IN_LOOPBACKNET)
			return 1;
	}
	return 0;
}
#endif


/*
 * read in the configuration file and setup for running.
 */
int
read_oldconfig(file)
	char *file;
{
	char cline[512], *s, prog[257], *mb = NULL;
	var_t *m = NULL;
	FILE *fp;
	int i;

	/*
	 * The old syslogd has a number of sources but they are all considered
	 * the same so far as which destinations they may go to.
	 */
	new_var("syslog", VAR_SRC);
	new_obj("syslog");
	(void) add_obj(SRC_FILE, new_file(SRC_FILE, PATH_KLOG));
#ifdef USE_LOG_UNIX_DGRAM
	(void) add_obj(SRC_UNIX, new_unix(SRC_UNIX, NET_UNIX_DGRAM, PATH_DEV_LOG));
#else
  #ifdef USE_SUN_STREAMS
  	(void) add_obj(SRC_SUN_STREAM, new_sunstream(SRC_SUN_STREAM, PATH_DEV_LOG));
  #else
	(void) add_obj(SRC_UNIX, new_unix(SRC_UNIX, NET_UNIX_STREAM, PATH_DEV_LOG));
  #endif
#endif
	(void) add_obj(SRC_INET, new_net(SRC_INET, NET_UDP, "0.0.0.0", "514"));
	end_obj();

#ifdef	USE_M4_PREPROCESS

	snprintf(prog, sizeof(prog), "echo '%s' | %s - %s",
		am_i_loghost() ? "define(LOGHOST, 1)" : "", PATH_M4, file);

	if (!(fp = popen(prog, "r")))
		return -1;
#else
	if (!(fp = fopen(file, "r")))
		return -1;
#endif

	*prog = '\0';

	while (fgets(cline, sizeof(cline), fp)) {
		for (s = cline; *s && isspace(*s); s++)
			;
		if (!*s)
			continue;
		if (*s == '#') {
			s++;
			if (*s != '!')
				continue;
		}
		if (*s == '!') {
			s++;
			if (mb)
				free(mb);
			while (isspace(*s))
				s++;
			if (!*s)
				*prog = '\0';
			else {
				for (i = 0; i < (int) (sizeof(prog) - 1); i++) {
					if (!isalnum(s[i]))
						break;
					prog[i] = s[i];
				}
				prog[i] = 0;
			}
			m = add_obj(FIL_MATCHPROG, new_matchprog(prog));
			end_obj();
			continue;
		}
		for (s = strchr(cline, '\0'); isspace(*--s);)
			continue;
		*++s = '\0';
		cfline(cline, m);
	}

	fclose(fp);

	/*
	 * Redisplay the configuration file as we see it.
	 */
	if (opts & (OPT_DEBUG))
		dump_all();

	return 0;

}
