/***************************************************************************
 *
 * Copyright (c) 1998 Balazs Scheidler
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __NSYSLOGD_H
#define __NSYSLOGD_H

#include <stdio.h>

typedef	struct options	{
	time_t	op_markfreq;	/* how long between marks */
	int	op_syncfreq;	/* how many messages between fsync's */
	char	*op_logdir;	/* default dir. for log files */
	char	*op_sysdir;	/* default dir. for syslog config files */
	char	*op_chroot;	/* directory to chroot to */
	char	*op_hashtype;
	char	*op_hashdir;
	char	*op_hashext;
} options_t;


extern	int	opts;
extern	int	yydebug;
extern	FILE	*yyin;
extern	int	started;
extern	options_t	options;

#define	OPT_DEBUG	0x1
#define	OPT_VERBOSE	0x2
#define	OPT_OLDSYSLOG	0x4

#endif
