/***************************************************************************
 *
 * Copyright (c) 1998 Balazs Scheidler
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __HTCP_H
#define __HTCP_H

#include "config.h"

#include "hash.h"
#include "var.h"

#define MAX_COMMAND_SIZE	12
#define MAX_SECRET_SIZE		30
#define MAX_SALT_SIZE		128

typedef (*htcp_input_proc)(filetable_entry_t *, struct sockaddr *, char *line);

typedef struct htcp_header {
	struct htcp_header *hh_next;
	char *hh_name;
	char *hh_value;
} htcp_header_t;

typedef struct htcp_state {
	int hs_req_state;
	int hs_next_state;	/* used by the client code */
	int hs_conn_flags;
	struct sockaddr *hs_clientaddr;
	htcp_input_proc hs_input_proc;
	hashalgo_t *hs_hashing;
	char hs_secret[MAX_SECRET_SIZE];
	char *hs_my_salt;
	int hs_my_salt_size;
	char *hs_his_salt;
	int hs_his_salt_size;
	char hs_req_cmd[MAX_COMMAND_SIZE];
	char *hs_req_param;
	htcp_header_t *hs_req_headers;
	int hs_reply_status;
	htcp_header_t *hs_reply_headers;
	char hs_linebuf[MAXLINE];
	char hs_linehash[MAXHASHSTR];
} htcp_state_t;

typedef struct htcp_command {
	char hc_cmd[MAX_COMMAND_SIZE];
	int (*hc_reply)(int, htcp_state_t *hs);
} htcp_command_t;

#define HTCP_PREOPEN			0
#define HTCP_SRV_PRECOMMAND		1
#define HTCP_SRV_PREHEADER		2
#define HTCP_SRV_REPLY_STATUS		3
#define HTCP_SRV_REPLY_HEADERS		4
#define HTCP_SRV_ACCEPT_LOG		5
#define HTCP_SRV_ACCEPT_HASH		6

#define HTCP_CLIENT_COMMAND		10
#define HTCP_CLIENT_HEADERS		11
#define HTCP_CLIENT_GETSTAT		12
#define HTCP_CLIENT_GETHEADERS		13
#define HTCP_CLIENT_CHECKIN		14
#define HTCP_CLIENT_POST_CHECKIN	15
#define HTCP_CLIENT_AUTH		16
#define HTCP_CLIENT_POST_AUTH		17
#define HTCP_CLIENT_IDLE		18
#define HTCP_CLIENT_SENDLOG		19

#define HTCP_F_CHECKEDIN	0x000000001
#define HTCP_F_AUTHORIZED	0x000000002
#define HTCP_F_LOGALLOWED	0x000000003

#define HTCP_F_LOGGING_IN	0x000000004


extern	void	htcp_init_client	__P((htcp_state_t *, char *));
extern	void	htcp_init_server	__P((htcp_state_t *, char *, struct sockaddr *, int, htcp_input_proc));
extern	int	htcp_server		__P((int fd, htcp_state_t *));
extern	int	htcp_client		__P((int fd, htcp_state_t *));
extern	int	htcp_close		__P((int fd, htcp_state_t *));
extern	int	htcp_sendlog		__P((int fd, htcp_state_t *, char *logline));

#endif
