/***************************************************************************
 *
 * Copyright (c) 1998 Balazs Scheidler
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __FILTERS_H
#define __FILTERS_H

typedef struct matchspec {
	struct matchspec *ms_next;
	int ms_cnt;
	char *ms_match;
#ifdef USE_POSIX_REGEX
	regex_t ms_buf;
#else
	char *ms_buf;
#endif
	int ms_comp;
} matchspec_t;

extern	matchspec_t	*mslist;

#define	MATCHSZ	512

typedef struct matchfilespec {
	struct matchfilespec *mf_next;
	int mf_cnt;
	char *mf_file;
	int mf_nlines;
#ifdef USE_POSIX_REGEX
	regex_t **mf_bufs;
#else
	char **mf_bufs;
#endif
	int mf_comp;
} matchfilespec_t;

extern	matchfilespec_t	*mfslist;


typedef	struct	matchprogspec	{
	struct matchprogspec *mp_next;
	int mp_cnt;
	char *mp_prog;
	int mp_comp;
} matchprogspec_t;

extern	matchprogspec_t	*mpslist;

typedef struct nmaskspec {
	struct nmaskspec *nm_next;
	int nm_cnt;
	char *nm_parm;
	struct in_addr nm_addr;
	struct in_addr nm_mask;
	int nm_comp;
} nmaskspec_t;

extern	nmaskspec_t	*nmlist;

#define	OK_INET(src, nm)	((((sin_t *)src)->sin_addr.s_addr & \
				 (nm)->nm_mask.s_addr) == (nm)->nm_addr.s_addr)

typedef struct facspec {
	struct facspec *fs_next;
	int fs_cnt;
	int fs_fac;
	int fs_comp;
} facspec_t;

typedef struct prispec {
	struct prispec *ps_next;
	int ps_cnt;
	int ps_pri;
	int ps_not;
	int ps_comp;
} prispec_t;

typedef struct facprispec {
	struct facprispec *fp_next;
	int fp_cnt;
	int fp_facpri;
	int fp_comp;
	int fp_not;
} facprispec_t;

#define	OK_PRI(a,b)	(((a) & LOG_PRIMASK) <= ((b) & LOG_PRIMASK))
#define	OK_FAC(a,b)	(((a) & LOG_FACMASK) == ((b) & LOG_FACMASK))

/* filter specification */
typedef struct fillist {
	struct fillist *fl_and;
	struct fillist *fl_or;
	var_t *fl_fil;
	int fl_comp;
} fillist_t;

#endif
