/***************************************************************************
 *
 * Copyright (c) 1998 Balazs Scheidler
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __AFSTREAMS_H
#define __AFSTREAMS_H

#include "config.h"
#include "ftable.h"

typedef struct streamspec {
	struct streamspec *ss_next;
	int ss_mode;
	int ss_cnt;	/* reference count */
	int ss_fd;	/* fd to the open file */
	char *ss_path;	/* path to the sun stream file */
} streamspec_t;

extern	streamspec_t	*sslist;

extern	void	afstreams_open_stream	__P((streamspec_t *));
extern	int	afstreams_check_fd	__P((int, filetable_entry_t *));

#endif

