/***************************************************************************
 *
 * Copyright (c) 1998 Balazs Scheidler
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Based on the original nsyslog by
 *
 * Copyright (C) 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 ***************************************************************************/

#ifndef __AFPIPE_H
#define __AFPIPE_H

#include "config.h"
#include "ftable.h"

typedef struct cmdspec {
	struct cmdspec *cm_next;
	int cm_cnt;
	int cm_mode;
	int cm_fd;
	char *cm_path;
} cmdspec_t;

extern	cmdspec_t	*cslist;

extern	int	afpipe_check_fd		__P((int, filetable_entry_t *));
extern	int	afpipe_reconnect	__P((filetype_t *));
extern	int	afpipe_open_pipe	__P((cmdspec_t *));

#endif
