#!/usr/bin/perl
$rcsid = "$Id: conf-convert.pl,v 1.1 1998/10/19 19:30:18 bazsi Exp $";

$infile="/etc/syslog.conf";
$filtcount = 0;
$destcount = 0;
$matchcount = 0;
$domatch = -1;

sub psrc {
	if ($domatch != -1) {
		print "log { source src; filter m$domatch;";
	} else {
		print "log { source src;";
	}
}

print "# $infile converted\n";
print "#\n\n";
print "source src { file /dev/klog; udp 0.0.0.0,514; unix /dev/log; };\n";
print "#\n";

open(I, "m4 $infile|") || die $!;

while(<I>) {
	chop;
	s/^#\!/\!/;
	s/([^#]*)#.*/$1/;
	next if (!length);
	print "#\n# $_\n#\n";
	if (/^\!.*/) {
		s/^\!//;
		s/^\s*(\S*)/$1/;
		print "filter m$matchcount {";
		print " match-prog $_; };\n";
		$domatch = $matchcount;
		$matchcount++;
		next;
	}
	@F = split;
	$dest = $F[$#F];
	if (!defined($destinations{$dest})) {
		$destinations{$dest} = $destcount;
		print "destination d$destcount {";
		if ($dest =~ /^\//) {
			print " file $dest";
		} elsif ($dest =~ /^\@/) {
			$dest =~ s/^\@//;
			print " udp $dest,514";
		} else {
			print " user $dest";
		}
		print "; };\n";
		$destcount++;
	}

	@D = split(/;/, $F[0]);
	foreach $d (@D) {
		$d =~ s/\./,/;
		@fp = split(/,/, $d);
		# lookout for wildcards
		if ( $fp[0] =~ /^\*$/ && $fp[1] =~ /^\*$/) {
			&psrc;
			print " destination d$destinations{$dest}; };\n";
		} elsif ( $fp[0] =~ /^\*$/ ) {
			if (!defined($filters{$d})) {
				$filters{$d} = $filcount;
				print "filter f$filcount {";
				print " priority $fp[1]; };\n";
				$filcount++;
			}
			&psrc;
			print " filter f$filters{$d};";
			print " destination d$destinations{$dest}; };\n";
		} elsif ( $fp[1] =~ /^\*$/ ) {
			if (!defined($filters{$d})) {
				$filters{$d} = $filcount;
				print "filter f${filcount} {";
				print " facility $fp[0]; };\n";
				$filcount++;
			}
			&psrc;
			print " filter f$filters{$d};";
			print " destination d$destinations{$dest}; };\n";
		} else {
			if (!defined($filters{$d})) {
				$filters{$d} = $filcount;
				print "filter f$filcount {";
				print " facpri $d; };\n";
				$filcount++;
			}
			&psrc;
			print " filter f$filters{$d};";
			print " destination d$destinations{$dest}; };\n";
		}
	}
}
close(<I>);
