/*
 * MakeURL.c
 *
 * Converts funny characters in a path name (given as command line argument)
 * into URL escape codes and prints it to stdout. Example:
 *
 * "this URL"
 *
 * is converted to
 *
 * "this%20URL"
 *
 * $Id: MakeURL.c,v 1.1 1998/02/14 17:40:55 hans Rel $
 */
#include <stdio.h>
#include <stdlib.h>

char table[256] =
{
	"                "
	"                "
	" !  $ &'()*+,-./"
	"0123456789:; = ?"
	"@ABCDEFGHIJKLMNO"
	"PQRSTUVWXYZ \\  _"
	" abcdefghijklmno"
	"pqrstuvwxyz     "
	"                "
	"                "
	"                "
	"                "
	"                "
	"                "
	"                "
	"                "
};

int main(int argc, char **argv)
{
	int		pos = 0;
	unsigned	c;

	if (argc != 2)
	{
		fprintf(stderr, "usage: %s path\n", argv[0]);
		exit(EXIT_FAILURE);
	}

	while (argv[1][pos] != '\0')
	{
		c = argv[1][pos++];
		if (c > 255)
		{
			fprintf(stderr, "%s: cannot handle multibyte characters\n");
			exit(EXIT_FAILURE);
		}

		if (table[c] == ' ')
			printf("%%%.2X", c);
		else
			printf("%c", c);
	}

	exit(EXIT_SUCCESS);
}

