#!/bin/sh
#
# usradmin.sh - menu for administrating user accounts
#
#		This menu is intended to be run with root privileges
#
ISPUTIL="/var/lib/ISPutil"
BBSUTIL="/var/lib/BBSutil"
hostname=`hostname`
dnsdomainname=`dnsdomainname`
TITLE="$hostname.$dnsdomainname User Admin"
SYSOPEDITOR="/usr/bin/pico"

export EDITOR="$SYSOPEDITOR"
export VISUAL="$EDITOR"


tsale()
{
TDONE=
while [ -z $TDONE ]; do
    reset
    dialog --title " $TITLE" \
    --menu "Online Hours Sale" 10 50 4 \
    "BACK"   "Back out of menu" \
    "1"      "1 block of 15 hours" \
    "2"    "2 blocks of 15 hours" \
    "3"    "3 blocks of 15 hours" \
    "X=EXIT" "Exit this menu" 2> /tmp/usradmin.$$
    if [ $? = 1 -o $? = 255 ]; then
            /bin/rm -f /tmp/usradmin.$$
            exit
    fi
    mchoice=`cat /tmp/usradmin.$$`
    /bin/rm -f /tmp/usradmin.$$
    if [ "$mchoice" = "BACK" ]; then
    TDONE=DONE
    fi
    if [ "$mchoice" = "1" ]; then
    $ISPUTIL/util/selltime.sh
    fi
    if [ "$mchoice" = "2" ]; then
    $ISPUTIL/util/selltime2.sh
    fi
    if [ "$mchoice" = "3" ]; then
    $ISPUTIL/util/selltime3.sh
    fi
    if [ "$mchoice" = "X=EXIT" ]; then
    TDONE=DONE
    fi
done
}


msale()
{
MSDONE=
while [ -z $MSDONE ]; do
    reset
    dialog --title " $TITLE" \
    --menu "Sell Months of Access" 10 55 4 \
    "BACK"   "Back out of menu" \
    "1"      "1 month internet access" \
    "2"    "2 months internet access" \
    "3"    "3 months internet access" \
    "X=EXIT" "Exit this menu" 2> /tmp/usradmin.$$
    if [ $? = 1 -o $? = 255 ]; then
            /bin/rm -f /tmp/usradmin.$$
            exit
    fi
    mchoice=`cat /tmp/usradmin.$$`
    /bin/rm -f /tmp/usradmin.$$
    if [ "$mchoice" = "BACK" ]; then
    MSDONE=DONE
    fi
    if [ "$mchoice" = "1" ]; then
    $ISPUTIL/util/sellmonth.sh
    fi
    if [ "$mchoice" = "2" ]; then
    $ISPUTIL/util/sellmonth2.sh
    fi
    if [ "$mchoice" = "3" ]; then
    $ISPUTIL/util/sellmonth3.sh
    fi
    if [ "$mchoice" = "X=EXIT" ]; then
    MSDONE=DONE
    fi
done
}


ushell()
{
USDONE=
while [ "$USDONE" = "" ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Modify User Shell" 13 50 6 \
        "ARREAR" "Arrear user" \
	"BACK"   "Back from menu" \
	"PPP"    "PPP user" \
	"RETIRE" "Retire user" \
	"SLIP"   "SLIP user" \
        "X=EXIT" "Exit Menu" 2> /tmp/usradmin.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/usradmin.$$
                exit
        fi
	mchoice=`cat /tmp/usradmin.$$`
        /bin/rm -f /tmp/usradmin.$$

        if [ "$mchoice" = "ARREAR" ]; then
        $ISPUTIL/util/arrear.sh
        fi
        if [ "$mchoice" = "BACK" ]; then
          USDONE=DONE
        fi
        if [ "$mchoice" = "PPP" ]; then
          $ISPUTIL/util/makeppp.sh
        fi
        if [ "$mchoice" = "SLIP" ]; then
          $ISPUTIL/util/makeslip.sh
        fi
        if [ "$mchoice" = "RETIRE" ]; then
          $ISPUTIL/util/retire.sh
        fi
        if [ "$mchoice" = "X=EXIT" ]; then
          USDONE=DONE
        fi
done
}

umodify()
{
MDONE=
while [ "$MDONE" = "" ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Modify User Accounts" 16 50 9 \
	"BACK"   "Back from menu" \
	"CLIDB"  "Clients Database" \
	"DISK"   "Disk quota" \
	"LIMIT"  "Set Timelimit" \
	"MONTHS" "Months sale" \
	"NEW"    "New user" \
	"PASSWD" "Set Password" \
	"SHELL" "Assign Shell" \
	"TIME"   "Time sale" \
        "X=EXIT" "Exit Menu" 2> /tmp/usradmin.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/usradmin.$$
                exit
        fi
	mchoice=`cat /tmp/usradmin.$$`
        /bin/rm -f /tmp/usradmin.$$

        if [ "$mchoice" = "BACK" ]; then
          MDONE=DONE
        fi
        if [ "$mchoice" = "CLIDB" ]; then
          $ISPUTIL/bin/launch clients
        fi
        if [ "$mchoice" = "DISK" ]; then
          dialog --title "Edit quotas" \
		--inputbox "User to Edit:" 15 46 2> /tmp/usradmin.$$
	  /usr/sbin/edquota -u `cat /tmp/usradmin.$$`
	  /bin/rm -f /tmp/usradmin.$$ 
	fi
	if [ "$mchoice" = "LIMIT" ]; then
	  $ISPUTIL/util/timeset.sh
	fi
	if [ "$mchoice" = "PASSWD" ]; then
	  dialog --title "Change a user's password" \
		--inputbox "User to Change:" 15 46 2> /tmp/quser.tmp.$$
	  user=`cat /tmp/quser.tmp.$$`
	  /bin/rm -f /tmp/quser.tmp.$$
	  grp=`id -gn $user`
	  if ["$grp"="users" -o "$grp"="slipin" -o "$grp"="guest"]; then
	    /bin/passwd $user
	  else
#	    cat > /tmp/quser.tmp.$$ <<-EOF
#	    echo The specified user was not found or your
#	    permissions are not set for editting that
#	    user, or the user is not subject to change.
#EOF 
	    dialog --title "Error: Unable to edit $user" \
		--textbox /tmp/quser.tmp.$$ 12 65
	    /bin/rm -f /tmp/quser.tmp.$$
	    /bin/rm -f /tmp/usradmin.$$
	  fi
	fi
        if [ "$mchoice" = "MONTHS" ]; then
          msale
        fi
        if [ "$mchoice" = "NEW" ]; then
          $ISPUTIL/bin/user_new
        fi
        if [ "$mchoice" = "SHELL" ]; then
          ushell
        fi
        if [ "$mchoice" = "TIME" ]; then
          tsale
        fi
        if [ "$mchoice" = "X=EXIT" ]; then
          MDONE=DONE
        fi
done
}

ureports()
{
RDONE=
while [ "$RDONE" = "" ]; do
	reset
	dialog --title " $TITLE" \
        --menu "Reports and Lists" 15 50 9 \
	"ARREARS" "Arrears users" \
        "DISK"    "Disk quotas" \
        "FIRST"   "Users by firstname" \
	"IDNUM"   "Users by UID number" \
        "NEW"     "New (unvalidated) users" \
        "ONLINE"  "Online users" \
	"RETIRED" "Retired users" \
        "UNAME"   "Users by username" \
        "X=EXIT"  "Exit Menu" 2> /tmp/usradmin.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/usradmin.$$
                exit
        fi
        rchoice=`cat /tmp/usradmin.$$`
        /bin/rm -f /tmp/usradmin.$$

        if [ "$rchoice" = "ARREARS" ]; then
	cat /etc/passwd | grep /shells/arrears | sort -fdbit ":" \
		| $ISPUTIL/usrlist.awk > /tmp/usradmin.$$
	dialog --title "`hostname`: Arrears Users" \
	--textbox /tmp/usradmin.$$ 22 76
	/bin/rm -f /tmp/usradmin.$$
        fi
        if [ "$rchoice" = "DISK" ]; then
        /usr/sbin/repquota -a >/tmp/usradmin.$$
        dialog --title "User disk quotas" \
        --textbox /tmp/usradmin.$$ 18 76
        /bin/rm -f /tmp/usradmin.$$
        fi
        if [ "$rchoice" = "FIRST" ]; then
	cat /etc/passwd | sort -fdbit ":" +4 \
		| $ISPUTIL/usrlist.awk > /tmp/usradmin.$$
	dialog --title "`hostname`'s Users" \
	--textbox /tmp/usradmin.$$ 22 76
	/bin/rm -f /tmp/usradmin.$$      
        fi
        if [ "$rchoice" = "IDNUM" ]; then
	cat /etc/passwd | sort -rfndbit ":" +2 \
		| $ISPUTIL/usrlist.awk > /tmp/usradmin.$$
	dialog --title "`hostname`'s Users" \
	--textbox /tmp/usradmin.$$ 22 76
	/bin/rm -f /tmp/usradmin.$$
        fi
        if [ "$rchoice" = "NEW" ]; then
	cat /etc/passwd | sort -fndbit ":" +2 \
		| $ISPUTIL/nusrlist.awk > /tmp/usradmin.$$
	dialog --title "`hostname`: Unvalidated Users" \
	--textbox /tmp/usradmin.$$ 22 76
	/bin/rm -f /tmp/usradmin.$$
        fi
	if [ "$rchoice" = "ONLINE" ]; then
	/usr/bin/finger @dialup1 > /tmp/usradmin.$$
        dialog --title "Users Online" \
        --textbox /tmp/usradmin.$$ 18 76
        /bin/rm -f /tmp/usradmin.$$
        fi
        if [ "$rchoice" = "RETIRED" ]; then
	cat /etc/passwd | grep /shells/retired | sort -fdbit ":" \
		| $ISPUTIL/usrlist.awk > /tmp/usradmin.$$
	dialog --title "`hostname`: Retired Users" \
	--textbox /tmp/usradmin.$$ 22 76
	/bin/rm -f /tmp/usradmin.$$
        fi
        if [ "$rchoice" = "UNAME" ]; then
	cat /etc/passwd | sort -fdbit ":" \
		| $ISPUTIL/usrlist.awk > /tmp/usradmin.$$
	dialog --title "`hostname`'s Users" \
	--textbox /tmp/usradmin.$$ 22 76
	/bin/rm -f /tmp/usradmin.$$
        fi
        if [ "$rchoice" = "X=EXIT" ]; then
        RDONE=DONE
        fi
done
}

DONE=
while [ "$DONE" = "" ]; do
	reset
	dialog --title " $TITLE " \
	--menu "MAIN" 12 40 3 \
	"MODIFY" "Modify users" \
	"REPORT" "View Reports" \
	"X=EXIT" "Exit" 2> /tmp/usradmin.$$
	if [ $? = 1 -o $? = 255 ]; then
		/bin/rm -f /tmp/tmpmsg.$$ /tmp/usradmin.$$
		exit
	fi
	choice=`cat /tmp/usradmin.$$`
	/bin/rm -f /tmp/usradmin.$$

        if [ "$choice" = "MODIFY" ]; then
        umodify
        fi
        if [ "$choice" = "REPORT" ]; then
        ureports
        fi
        if [ "$choice" = "X=EXIT" ]; then
        DONE=DONE
        fi
done
