#!/bin/sh
#
# user_init.sh -	initial setup for user accounts
#
#	This routine is called by the user_new routine in BBSutil.
#

# where is utilities library:
ISPUTIL="/var/lib/ISPutil"
ISPDBS="/var/lib/ISPutil/qdDBs"
USERDB=$ISPDBS/Clients
# where is WWWutil package
WWWUTIL="/var/lib/WWWutil"
PAGEMAKE=$WWWUTIL/pagemake

# where is qddb query program
QDDBBIN=/usr/local/qddb/bin
QUERY=$QDDBBIN/query

# where is mailhost:
MAILHOST="mail.cin-tech.ns.ca"
# where is webserver:
WEBSERVER="www.cin-tech.ns.ca"

if [ "$USER" = "" ]; then
  USER=$LOGNAME
fi
user=$1
echo
if [ "$user" = "" ]; then
  echo "No username given."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi
pwln=`grep "^$user:" /etc/passwd`
if [ "$pwln" = "" ]; then
  echo "Username $user not found in user-database."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi
name=`echo $pwln | cut -d ":" -f 5`
group=`echo $pwln | cut -d ":" -f 4`
echo
if [ "$group" != "26" ]; then
  echo "Sorry, user $user is not a member of the group slipin."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi

#
# correct the permissions on their home directory, make homepage etc
#
$ISPUTIL/util/mkslipinhome.sh $user

#
# set their quota same as "guest" is set
#
/usr/sbin/edquota -p guest $user

#
# subscribe them to the users mailing-list
#
mail majordomo@$MAILHOST <<EOF
subscribe users $user
EOF

#
# append them to forwarding database
#
echo $user $user@mail >> /etc/smail/forward
/usr/lib/smail/mkforward
