#!/bin/sh
#
# timeset.sh - set a user's time allottment
#

# where are BBSutil programs:
BBSUTIL="/var/lib/BBSutil"

# where is our mail host
MAILHOST="mail.cin-tech.ns.ca"

# user priority
PRIORITY="4"

reset
echo "Set a user's timelimit"
echo "----------------------"
echo
if [ "$USER" = "" ]; then
  USER=$LOGNAME
fi
echo "Salesperson is: $USER"
echo
echo "What is the username whose timelimit you wish to change?"
echo
echo -n "Username: "
read user
echo
if [ "$user" = "" ]; then
  echo "No username given."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi
pwln=`grep ^$user: /etc/passwd`
if [ "$pwln" = "" ]; then
  echo "Username $user not found in user-database."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi
name=`echo $pwln | cut -d ":" -f 5`
echo "User's realname: $name"
group=`id -gn $user`
echo "User's group is: $group"
echo
if [ "$group" != "guest" -a "$group" != "slipin" -a "$group" != "users" ]; then
  echo "Sorry, user $user is not in the guest, users or slipin groups."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi
$BBSUTIL/user_data $user
echo
echo -n "Are you sure about this? [N/y]: "
read i
case $i in
    y) ;;
  yes) ;;
    Y) ;;
  Yes) ;;
  YES) ;;
    *) exit ;;
esac
echo
echo "Changing $user's timelimit for $USER ..."
echo
echo -n "New minutes limit: "
read newtime
$ISPUTIL/doas 16 $BBSUTIL/user_time $user 0 $newtime $newtime $PRIORITY
$ISPUTIL/doas 16 $BBSUTIL/user_data $user
echo
echo `date`" timeset: $USER changed $user to $newtime timelimit" \
	>> /var/adm/isputil.log
mail -s "timeset: $USER changed $user to $newtime timelimit" \
	accounts@$MAILHOST -c $USER <<-EOF
	$USER changed $user to $newtime timelimit
	EOF
echo -n "[ Press Enter ]"
read
