#!/bin/sh
#
# setquota.sh - set a new user's disk quota
#
#	This script should be executable only by root
#	That ensures a person must already have root privs to run it.
#	It then uses super to complete their privs to really be root
#	because edquota is picky enough it needs full root privs.
#
# make this a 'super' script:
prog=`basename $0`
test "X$SUPERCMD" = "X$prog" || exec /usr/bin/super $prog ${1+"$@"}

# do the job
/usr/bin/super /usr/sbin/edquota -p guest $1
